﻿// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using Apache.Arrow.Flight;
using Google.Protobuf;

namespace Apache.Arrow.Flight
{
    internal static class SchemaWriter
    {
        public static ByteString ToByteString(this Schema schema)
        {
            return schema == null ?
                ByteString.Empty :
                UnsafeByteOperations.UnsafeWrap(ArrowSerializationHelpers.SerializeSchema(schema));
        }
    }
}

public static class SchemaExtension
{
    // This should never have been a public class without a namespace
    [Obsolete("Use ArrowSerializationHelpers.SerializeSchema instead")]
    public static ByteString ToByteString(this Apache.Arrow.Schema schema)
    {
        return SchemaWriter.ToByteString(schema);
    }
}
