//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Protocol Buffers describing the external transforms available.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v5.27.3
// source: org/apache/beam/model/pipeline/v1/external_transforms.proto

package pipeline_v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ExpansionMethods_Enum int32

const (
	// Expand a Java transform using specified constructor and builder methods.
	// Transform payload will be of type JavaClassLookupPayload.
	ExpansionMethods_JAVA_CLASS_LOOKUP ExpansionMethods_Enum = 0
	// Expanding a SchemaTransform identified by the expansion service.
	// Transform payload will be of type  SchemaTransformPayload.
	ExpansionMethods_SCHEMA_TRANSFORM ExpansionMethods_Enum = 1
)

// Enum value maps for ExpansionMethods_Enum.
var (
	ExpansionMethods_Enum_name = map[int32]string{
		0: "JAVA_CLASS_LOOKUP",
		1: "SCHEMA_TRANSFORM",
	}
	ExpansionMethods_Enum_value = map[string]int32{
		"JAVA_CLASS_LOOKUP": 0,
		"SCHEMA_TRANSFORM":  1,
	}
)

func (x ExpansionMethods_Enum) Enum() *ExpansionMethods_Enum {
	p := new(ExpansionMethods_Enum)
	*p = x
	return p
}

func (x ExpansionMethods_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExpansionMethods_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_enumTypes[0].Descriptor()
}

func (ExpansionMethods_Enum) Type() protoreflect.EnumType {
	return &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_enumTypes[0]
}

func (x ExpansionMethods_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExpansionMethods_Enum.Descriptor instead.
func (ExpansionMethods_Enum) EnumDescriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescGZIP(), []int{1, 0}
}

type ManagedTransforms_Urns int32

const (
	ManagedTransforms_ICEBERG_READ     ManagedTransforms_Urns = 0
	ManagedTransforms_ICEBERG_WRITE    ManagedTransforms_Urns = 1
	ManagedTransforms_KAFKA_READ       ManagedTransforms_Urns = 2
	ManagedTransforms_KAFKA_WRITE      ManagedTransforms_Urns = 3
	ManagedTransforms_BIGQUERY_READ    ManagedTransforms_Urns = 4
	ManagedTransforms_BIGQUERY_WRITE   ManagedTransforms_Urns = 5
	ManagedTransforms_ICEBERG_CDC_READ ManagedTransforms_Urns = 6
)

// Enum value maps for ManagedTransforms_Urns.
var (
	ManagedTransforms_Urns_name = map[int32]string{
		0: "ICEBERG_READ",
		1: "ICEBERG_WRITE",
		2: "KAFKA_READ",
		3: "KAFKA_WRITE",
		4: "BIGQUERY_READ",
		5: "BIGQUERY_WRITE",
		6: "ICEBERG_CDC_READ",
	}
	ManagedTransforms_Urns_value = map[string]int32{
		"ICEBERG_READ":     0,
		"ICEBERG_WRITE":    1,
		"KAFKA_READ":       2,
		"KAFKA_WRITE":      3,
		"BIGQUERY_READ":    4,
		"BIGQUERY_WRITE":   5,
		"ICEBERG_CDC_READ": 6,
	}
)

func (x ManagedTransforms_Urns) Enum() *ManagedTransforms_Urns {
	p := new(ManagedTransforms_Urns)
	*p = x
	return p
}

func (x ManagedTransforms_Urns) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedTransforms_Urns) Descriptor() protoreflect.EnumDescriptor {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_enumTypes[1].Descriptor()
}

func (ManagedTransforms_Urns) Type() protoreflect.EnumType {
	return &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_enumTypes[1]
}

func (x ManagedTransforms_Urns) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedTransforms_Urns.Descriptor instead.
func (ManagedTransforms_Urns) EnumDescriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescGZIP(), []int{2, 0}
}

type Annotations_Enum int32

const (
	// The annotation key for the encoded configuration Row used to build a transform
	Annotations_CONFIG_ROW_KEY Annotations_Enum = 0
	// The annotation key for the configuration Schema used to decode the configuration Row
	Annotations_CONFIG_ROW_SCHEMA_KEY Annotations_Enum = 1
	// If ths transform is a SchemaTransform, this is the annotation key for the SchemaTransform's URN
	Annotations_SCHEMATRANSFORM_URN_KEY Annotations_Enum = 2
	// If the transform is a ManagedSchemaTransform, this is the annotation key for the underlying SchemaTransform's URN
	Annotations_MANAGED_UNDERLYING_TRANSFORM_URN_KEY Annotations_Enum = 3
)

// Enum value maps for Annotations_Enum.
var (
	Annotations_Enum_name = map[int32]string{
		0: "CONFIG_ROW_KEY",
		1: "CONFIG_ROW_SCHEMA_KEY",
		2: "SCHEMATRANSFORM_URN_KEY",
		3: "MANAGED_UNDERLYING_TRANSFORM_URN_KEY",
	}
	Annotations_Enum_value = map[string]int32{
		"CONFIG_ROW_KEY":                       0,
		"CONFIG_ROW_SCHEMA_KEY":                1,
		"SCHEMATRANSFORM_URN_KEY":              2,
		"MANAGED_UNDERLYING_TRANSFORM_URN_KEY": 3,
	}
)

func (x Annotations_Enum) Enum() *Annotations_Enum {
	p := new(Annotations_Enum)
	*p = x
	return p
}

func (x Annotations_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Annotations_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_enumTypes[2].Descriptor()
}

func (Annotations_Enum) Type() protoreflect.EnumType {
	return &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_enumTypes[2]
}

func (x Annotations_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Annotations_Enum.Descriptor instead.
func (Annotations_Enum) EnumDescriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescGZIP(), []int{5, 0}
}

// A configuration payload for an external transform.
// Used as the payload of ExternalTransform as part of an ExpansionRequest.
type ExternalConfigurationPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A schema for use in beam:coder:row:v1
	Schema *Schema `protobuf:"bytes,1,opt,name=schema,proto3" json:"schema,omitempty"`
	// A payload which can be decoded using beam:coder:row:v1 and the given
	// schema.
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *ExternalConfigurationPayload) Reset() {
	*x = ExternalConfigurationPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternalConfigurationPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalConfigurationPayload) ProtoMessage() {}

func (x *ExternalConfigurationPayload) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalConfigurationPayload.ProtoReflect.Descriptor instead.
func (*ExternalConfigurationPayload) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescGZIP(), []int{0}
}

func (x *ExternalConfigurationPayload) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

func (x *ExternalConfigurationPayload) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

// Defines specific expansion methods that may be used to expand cross-language
// transforms.
// Has to be set as the URN of the transform of the expansion request.
type ExpansionMethods struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExpansionMethods) Reset() {
	*x = ExpansionMethods{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExpansionMethods) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExpansionMethods) ProtoMessage() {}

func (x *ExpansionMethods) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExpansionMethods.ProtoReflect.Descriptor instead.
func (*ExpansionMethods) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescGZIP(), []int{1}
}

// Defines the URNs for managed transforms.
type ManagedTransforms struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ManagedTransforms) Reset() {
	*x = ManagedTransforms{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedTransforms) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedTransforms) ProtoMessage() {}

func (x *ManagedTransforms) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedTransforms.ProtoReflect.Descriptor instead.
func (*ManagedTransforms) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescGZIP(), []int{2}
}

// A configuration payload for an external transform.
// Used to define a Java transform that can be directly instantiated by a Java
// expansion service.
type JavaClassLookupPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the Java transform class.
	ClassName string `protobuf:"bytes,1,opt,name=class_name,json=className,proto3" json:"class_name,omitempty"`
	// A static method to construct the initial instance of the transform.
	// If not provided, the transform should be instantiated using a class
	// constructor.
	ConstructorMethod string `protobuf:"bytes,2,opt,name=constructor_method,json=constructorMethod,proto3" json:"constructor_method,omitempty"`
	// The top level fields of the schema represent the method parameters in
	// order.
	// If able, top level field names are also verified against the method
	// parameters for a match.
	// Any field names in the form 'ignore[0-9]+' will not be used for validation
	// hence that format can be used to represent arbitrary field names.
	ConstructorSchema *Schema `protobuf:"bytes,3,opt,name=constructor_schema,json=constructorSchema,proto3" json:"constructor_schema,omitempty"`
	// A payload which can be decoded using beam:coder:row:v1 and the provided
	// constructor schema.
	ConstructorPayload []byte `protobuf:"bytes,4,opt,name=constructor_payload,json=constructorPayload,proto3" json:"constructor_payload,omitempty"`
	// Set of builder methods and corresponding parameters to apply after the
	// transform object is constructed.
	// When constructing the transform object, given builder methods will be
	// applied in order.
	BuilderMethods []*BuilderMethod `protobuf:"bytes,5,rep,name=builder_methods,json=builderMethods,proto3" json:"builder_methods,omitempty"`
}

func (x *JavaClassLookupPayload) Reset() {
	*x = JavaClassLookupPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JavaClassLookupPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JavaClassLookupPayload) ProtoMessage() {}

func (x *JavaClassLookupPayload) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JavaClassLookupPayload.ProtoReflect.Descriptor instead.
func (*JavaClassLookupPayload) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescGZIP(), []int{3}
}

func (x *JavaClassLookupPayload) GetClassName() string {
	if x != nil {
		return x.ClassName
	}
	return ""
}

func (x *JavaClassLookupPayload) GetConstructorMethod() string {
	if x != nil {
		return x.ConstructorMethod
	}
	return ""
}

func (x *JavaClassLookupPayload) GetConstructorSchema() *Schema {
	if x != nil {
		return x.ConstructorSchema
	}
	return nil
}

func (x *JavaClassLookupPayload) GetConstructorPayload() []byte {
	if x != nil {
		return x.ConstructorPayload
	}
	return nil
}

func (x *JavaClassLookupPayload) GetBuilderMethods() []*BuilderMethod {
	if x != nil {
		return x.BuilderMethods
	}
	return nil
}

// This represents a builder method of the transform class that should be
// applied in-order after instantiating the initial transform object.
// Each builder method may take one or more parameters and has to return an
// instance of the transform object.
type BuilderMethod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the builder method
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The top level fields of the schema represent the method parameters in
	// order.
	// If able, top level field names are also verified against the method
	// parameters for a match.
	// Any field names in the form 'ignore[0-9]+' will not be used for validation
	// hence that format can be used to represent arbitrary field names.
	Schema *Schema `protobuf:"bytes,2,opt,name=schema,proto3" json:"schema,omitempty"`
	// A payload which can be decoded using beam:coder:row:v1 and the builder
	// method schema.
	Payload []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *BuilderMethod) Reset() {
	*x = BuilderMethod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuilderMethod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuilderMethod) ProtoMessage() {}

func (x *BuilderMethod) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuilderMethod.ProtoReflect.Descriptor instead.
func (*BuilderMethod) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescGZIP(), []int{4}
}

func (x *BuilderMethod) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BuilderMethod) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

func (x *BuilderMethod) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

type Annotations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Annotations) Reset() {
	*x = Annotations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Annotations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Annotations) ProtoMessage() {}

func (x *Annotations) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Annotations.ProtoReflect.Descriptor instead.
func (*Annotations) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescGZIP(), []int{5}
}

// Payload for a Schema-aware PTransform.
// This is a transform that is aware of its input and output PCollection schemas
// and is configured using Beam Schema-compatible parameters.
// The information available in the payload can be used to instantiate the schema-aware transform.
type SchemaTransformPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier of the SchemaTransform (typically a URN).
	Identifier string `protobuf:"bytes,1,opt,name=identifier,proto3" json:"identifier,omitempty"`
	// The configuration schema of the SchemaTransform.
	ConfigurationSchema *Schema `protobuf:"bytes,2,opt,name=configuration_schema,json=configurationSchema,proto3" json:"configuration_schema,omitempty"`
	// The configuration of the SchemaTransform.
	// Should be decodable via beam:coder:row:v1.
	// The schema of the Row should be compatible with the schema of the
	// SchemaTransform.
	ConfigurationRow []byte `protobuf:"bytes,3,opt,name=configuration_row,json=configurationRow,proto3" json:"configuration_row,omitempty"`
}

func (x *SchemaTransformPayload) Reset() {
	*x = SchemaTransformPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchemaTransformPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemaTransformPayload) ProtoMessage() {}

func (x *SchemaTransformPayload) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemaTransformPayload.ProtoReflect.Descriptor instead.
func (*SchemaTransformPayload) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescGZIP(), []int{6}
}

func (x *SchemaTransformPayload) GetIdentifier() string {
	if x != nil {
		return x.Identifier
	}
	return ""
}

func (x *SchemaTransformPayload) GetConfigurationSchema() *Schema {
	if x != nil {
		return x.ConfigurationSchema
	}
	return nil
}

func (x *SchemaTransformPayload) GetConfigurationRow() []byte {
	if x != nil {
		return x.ConfigurationRow
	}
	return nil
}

var File_org_apache_beam_model_pipeline_v1_external_transforms_proto protoreflect.FileDescriptor

var file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x6f, 0x72, 0x67, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x62, 0x65, 0x61,
	0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x1a, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x62, 0x65, 0x61,
	0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x37, 0x6f, 0x72, 0x67, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x62, 0x65, 0x61,
	0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x5f, 0x72, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x5f,
	0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x7b, 0x0a, 0x1c, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x41, 0x0a, 0x06, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x18, 0x0a, 0x07,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0xac, 0x01, 0x0a, 0x10, 0x45, 0x78, 0x70, 0x61, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x22, 0x97, 0x01, 0x0a, 0x04,
	0x45, 0x6e, 0x75, 0x6d, 0x12, 0x48, 0x0a, 0x11, 0x4a, 0x41, 0x56, 0x41, 0x5f, 0x43, 0x4c, 0x41,
	0x53, 0x53, 0x5f, 0x4c, 0x4f, 0x4f, 0x4b, 0x55, 0x50, 0x10, 0x00, 0x1a, 0x31, 0xa2, 0xb4, 0xfa,
	0xc2, 0x05, 0x2b, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x3a, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x3a, 0x6a, 0x61, 0x76, 0x61, 0x5f, 0x63,
	0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x3a, 0x76, 0x31, 0x12, 0x45,
	0x0a, 0x10, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f,
	0x52, 0x4d, 0x10, 0x01, 0x1a, 0x2f, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x29, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x3a, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x3a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x3a, 0x76, 0x31, 0x22, 0xd0, 0x04, 0x0a, 0x11, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x22, 0xba, 0x04, 0x0a, 0x04,
	0x55, 0x72, 0x6e, 0x73, 0x12, 0x4c, 0x0a, 0x0c, 0x49, 0x43, 0x45, 0x42, 0x45, 0x52, 0x47, 0x5f,
	0x52, 0x45, 0x41, 0x44, 0x10, 0x00, 0x1a, 0x3a, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x34, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x3a, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x69, 0x63, 0x65, 0x62, 0x65, 0x72, 0x67, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x3a,
	0x76, 0x31, 0x12, 0x4e, 0x0a, 0x0d, 0x49, 0x43, 0x45, 0x42, 0x45, 0x52, 0x47, 0x5f, 0x57, 0x52,
	0x49, 0x54, 0x45, 0x10, 0x01, 0x1a, 0x3b, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x35, 0x62, 0x65, 0x61,
	0x6d, 0x3a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x3a, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x3a, 0x69, 0x63, 0x65, 0x62, 0x65, 0x72, 0x67, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x3a,
	0x76, 0x31, 0x12, 0x48, 0x0a, 0x0a, 0x4b, 0x41, 0x46, 0x4b, 0x41, 0x5f, 0x52, 0x45, 0x41, 0x44,
	0x10, 0x02, 0x1a, 0x38, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x32, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6b,
	0x61, 0x66, 0x6b, 0x61, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x3a, 0x76, 0x31, 0x12, 0x4a, 0x0a, 0x0b,
	0x4b, 0x41, 0x46, 0x4b, 0x41, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x03, 0x1a, 0x39, 0xa2,
	0xb4, 0xfa, 0xc2, 0x05, 0x33, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x5f,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x56, 0x0a, 0x0d, 0x42, 0x49, 0x47, 0x51,
	0x55, 0x45, 0x52, 0x59, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x04, 0x1a, 0x43, 0xa2, 0xb4, 0xfa,
	0xc2, 0x05, 0x3d, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x3a, 0x76, 0x31,
	0x12, 0x50, 0x0a, 0x0e, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x57, 0x52, 0x49,
	0x54, 0x45, 0x10, 0x05, 0x1a, 0x3c, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x36, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x3a, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x3a,
	0x76, 0x31, 0x12, 0x54, 0x0a, 0x10, 0x49, 0x43, 0x45, 0x42, 0x45, 0x52, 0x47, 0x5f, 0x43, 0x44,
	0x43, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x06, 0x1a, 0x3e, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x38,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x69, 0x63, 0x65, 0x62, 0x65, 0x72, 0x67, 0x5f, 0x63, 0x64, 0x63,
	0x5f, 0x72, 0x65, 0x61, 0x64, 0x3a, 0x76, 0x31, 0x22, 0xcc, 0x02, 0x0a, 0x16, 0x4a, 0x61, 0x76,
	0x61, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x6f,
	0x72, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x6f, 0x72, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x12, 0x58, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x6f, 0x72,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x2f, 0x0a, 0x13, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x6f, 0x72, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x59, 0x0a, 0x0f,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65,
	0x72, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x22, 0x80, 0x01, 0x0a, 0x0d, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a,
	0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0xfa, 0x01, 0x0a, 0x0b, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xea, 0x01, 0x0a, 0x04, 0x45,
	0x6e, 0x75, 0x6d, 0x12, 0x24, 0x0a, 0x0e, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x52, 0x4f,
	0x57, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x00, 0x1a, 0x10, 0xaa, 0xb4, 0xfa, 0xc2, 0x05, 0x0a, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x72, 0x6f, 0x77, 0x12, 0x32, 0x0a, 0x15, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x5f, 0x52, 0x4f, 0x57, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x5f, 0x4b,
	0x45, 0x59, 0x10, 0x01, 0x1a, 0x17, 0xaa, 0xb4, 0xfa, 0xc2, 0x05, 0x11, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x36, 0x0a,
	0x17, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d,
	0x5f, 0x55, 0x52, 0x4e, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x02, 0x1a, 0x19, 0xaa, 0xb4, 0xfa, 0xc2,
	0x05, 0x13, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x5f, 0x75, 0x72, 0x6e, 0x12, 0x50, 0x0a, 0x24, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44,
	0x5f, 0x55, 0x4e, 0x44, 0x45, 0x52, 0x4c, 0x59, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x55, 0x52, 0x4e, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x03, 0x1a,
	0x26, 0xaa, 0xb4, 0xfa, 0xc2, 0x05, 0x20, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x75,
	0x6e, 0x64, 0x65, 0x72, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x5f, 0x75, 0x72, 0x6e, 0x22, 0xc3, 0x01, 0x0a, 0x16, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x12, 0x5c, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x13, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x12, 0x2b, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x6f, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x10, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x77, 0x42, 0x81, 0x01,
	0x0a, 0x21, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x42, 0x12, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x5a, 0x48, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f,
	0x73, 0x64, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x62,
	0x65, 0x61, 0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x76, 0x31, 0x3b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x76,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescOnce sync.Once
	file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescData = file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDesc
)

func file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescGZIP() []byte {
	file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescOnce.Do(func() {
		file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescData = protoimpl.X.CompressGZIP(file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescData)
	})
	return file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDescData
}

var file_org_apache_beam_model_pipeline_v1_external_transforms_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_org_apache_beam_model_pipeline_v1_external_transforms_proto_goTypes = []interface{}{
	(ExpansionMethods_Enum)(0),           // 0: org.apache.beam.model.pipeline.v1.ExpansionMethods.Enum
	(ManagedTransforms_Urns)(0),          // 1: org.apache.beam.model.pipeline.v1.ManagedTransforms.Urns
	(Annotations_Enum)(0),                // 2: org.apache.beam.model.pipeline.v1.Annotations.Enum
	(*ExternalConfigurationPayload)(nil), // 3: org.apache.beam.model.pipeline.v1.ExternalConfigurationPayload
	(*ExpansionMethods)(nil),             // 4: org.apache.beam.model.pipeline.v1.ExpansionMethods
	(*ManagedTransforms)(nil),            // 5: org.apache.beam.model.pipeline.v1.ManagedTransforms
	(*JavaClassLookupPayload)(nil),       // 6: org.apache.beam.model.pipeline.v1.JavaClassLookupPayload
	(*BuilderMethod)(nil),                // 7: org.apache.beam.model.pipeline.v1.BuilderMethod
	(*Annotations)(nil),                  // 8: org.apache.beam.model.pipeline.v1.Annotations
	(*SchemaTransformPayload)(nil),       // 9: org.apache.beam.model.pipeline.v1.SchemaTransformPayload
	(*Schema)(nil),                       // 10: org.apache.beam.model.pipeline.v1.Schema
}
var file_org_apache_beam_model_pipeline_v1_external_transforms_proto_depIdxs = []int32{
	10, // 0: org.apache.beam.model.pipeline.v1.ExternalConfigurationPayload.schema:type_name -> org.apache.beam.model.pipeline.v1.Schema
	10, // 1: org.apache.beam.model.pipeline.v1.JavaClassLookupPayload.constructor_schema:type_name -> org.apache.beam.model.pipeline.v1.Schema
	7,  // 2: org.apache.beam.model.pipeline.v1.JavaClassLookupPayload.builder_methods:type_name -> org.apache.beam.model.pipeline.v1.BuilderMethod
	10, // 3: org.apache.beam.model.pipeline.v1.BuilderMethod.schema:type_name -> org.apache.beam.model.pipeline.v1.Schema
	10, // 4: org.apache.beam.model.pipeline.v1.SchemaTransformPayload.configuration_schema:type_name -> org.apache.beam.model.pipeline.v1.Schema
	5,  // [5:5] is the sub-list for method output_type
	5,  // [5:5] is the sub-list for method input_type
	5,  // [5:5] is the sub-list for extension type_name
	5,  // [5:5] is the sub-list for extension extendee
	0,  // [0:5] is the sub-list for field type_name
}

func init() { file_org_apache_beam_model_pipeline_v1_external_transforms_proto_init() }
func file_org_apache_beam_model_pipeline_v1_external_transforms_proto_init() {
	if File_org_apache_beam_model_pipeline_v1_external_transforms_proto != nil {
		return
	}
	file_org_apache_beam_model_pipeline_v1_schema_proto_init()
	file_org_apache_beam_model_pipeline_v1_beam_runner_api_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExternalConfigurationPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExpansionMethods); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedTransforms); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JavaClassLookupPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuilderMethod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Annotations); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchemaTransformPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_org_apache_beam_model_pipeline_v1_external_transforms_proto_goTypes,
		DependencyIndexes: file_org_apache_beam_model_pipeline_v1_external_transforms_proto_depIdxs,
		EnumInfos:         file_org_apache_beam_model_pipeline_v1_external_transforms_proto_enumTypes,
		MessageInfos:      file_org_apache_beam_model_pipeline_v1_external_transforms_proto_msgTypes,
	}.Build()
	File_org_apache_beam_model_pipeline_v1_external_transforms_proto = out.File
	file_org_apache_beam_model_pipeline_v1_external_transforms_proto_rawDesc = nil
	file_org_apache_beam_model_pipeline_v1_external_transforms_proto_goTypes = nil
	file_org_apache_beam_model_pipeline_v1_external_transforms_proto_depIdxs = nil
}
