/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.jcajce.provider.ParametersCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IvParametersCreator<T extends ParametersWithIV>
implements ParametersCreator {
    private final ParametersWithIV baseParameters;

    IvParametersCreator(ParametersWithIV parametersWithIV) {
        this.baseParameters = parametersWithIV;
    }

    public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            return this.baseParameters.withIV(((IvParameterSpec)algorithmParameterSpec).getIV());
        }
        if (bl && this.baseParameters.getAlgorithm().requiresAlgorithmParameters()) {
            return this.baseParameters.withIV(secureRandom);
        }
        return this.baseParameters;
    }
}

