/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.segment;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.v1.MetadataSource;
import org.apache.cassandra.index.sai.disk.v1.MetadataWriter;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;

public class SegmentMetadata {
    private static final String NAME = "SegmentMetadata";
    public final long rowIdOffset;
    public final long minSSTableRowId;
    public final long maxSSTableRowId;
    public final long numRows;
    public final PrimaryKey minKey;
    public final PrimaryKey maxKey;
    public final ByteBuffer minTerm;
    public final ByteBuffer maxTerm;
    public final ComponentMetadataMap componentMetadatas;

    public SegmentMetadata(long rowIdOffset, long numRows, long minSSTableRowId, long maxSSTableRowId, PrimaryKey minKey, PrimaryKey maxKey, ByteBuffer minTerm, ByteBuffer maxTerm, ComponentMetadataMap componentMetadatas) {
        assert (numRows < Integer.MAX_VALUE);
        Objects.requireNonNull(minKey);
        Objects.requireNonNull(maxKey);
        Objects.requireNonNull(minTerm);
        Objects.requireNonNull(maxTerm);
        this.rowIdOffset = rowIdOffset;
        this.minSSTableRowId = minSSTableRowId;
        this.maxSSTableRowId = maxSSTableRowId;
        this.numRows = numRows;
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.minTerm = minTerm;
        this.maxTerm = maxTerm;
        this.componentMetadatas = componentMetadatas;
    }

    private SegmentMetadata(DataInput input, PrimaryKey.Factory primaryKeyFactory) throws IOException {
        this.rowIdOffset = input.readLong();
        this.numRows = input.readLong();
        this.minSSTableRowId = input.readLong();
        this.maxSSTableRowId = input.readLong();
        this.minKey = primaryKeyFactory.fromComparableBytes(ByteSource.fixedLength(SegmentMetadata.readBytes(input)));
        this.maxKey = primaryKeyFactory.fromComparableBytes(ByteSource.fixedLength(SegmentMetadata.readBytes(input)));
        this.minTerm = SegmentMetadata.readBytes(input);
        this.maxTerm = SegmentMetadata.readBytes(input);
        this.componentMetadatas = new ComponentMetadataMap(input);
    }

    public int toSegmentRowId(long sstableRowId) {
        return Math.toIntExact(sstableRowId - this.rowIdOffset);
    }

    public static List<SegmentMetadata> load(MetadataSource source, PrimaryKey.Factory primaryKeyFactory) throws IOException {
        DataInput input = source.get(NAME);
        int segmentCount = input.readVInt();
        ArrayList<SegmentMetadata> segmentMetadata = new ArrayList<SegmentMetadata>(segmentCount);
        for (int i = 0; i < segmentCount; ++i) {
            segmentMetadata.add(new SegmentMetadata(input, primaryKeyFactory));
        }
        return segmentMetadata;
    }

    public static void write(MetadataWriter writer, List<SegmentMetadata> segments) throws IOException {
        try (MetadataWriter.Builder output = writer.builder(NAME);){
            output.writeVInt(segments.size());
            for (SegmentMetadata metadata : segments) {
                output.writeLong(metadata.rowIdOffset);
                output.writeLong(metadata.numRows);
                output.writeLong(metadata.minSSTableRowId);
                output.writeLong(metadata.maxSSTableRowId);
                Stream.of(ByteSourceInverse.readBytes(metadata.minKey.asComparableBytes(ByteComparable.Version.OSS50)), ByteSourceInverse.readBytes(metadata.maxKey.asComparableBytes(ByteComparable.Version.OSS50))).forEach(b -> SegmentMetadata.writeBytes(b, output));
                Stream.of(metadata.minTerm, metadata.maxTerm).forEach(bb -> SegmentMetadata.writeBytes(bb, output));
                metadata.componentMetadatas.write(output);
            }
        }
    }

    public String toString() {
        return "SegmentMetadata{rowIdOffset=" + this.rowIdOffset + ", minSSTableRowId=" + this.minSSTableRowId + ", maxSSTableRowId=" + this.maxSSTableRowId + ", numRows=" + this.numRows + ", componentMetadatas=" + this.componentMetadatas + "}";
    }

    private static ByteBuffer readBytes(DataInput input) throws IOException {
        int len = input.readInt();
        byte[] bytes = new byte[len];
        input.readBytes(bytes, 0, len);
        return ByteBuffer.wrap(bytes);
    }

    private static void writeBytes(ByteBuffer buf, IndexOutput out) {
        try {
            byte[] bytes = ByteBufferUtil.getArray(buf);
            out.writeInt(bytes.length);
            out.writeBytes(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void writeBytes(byte[] bytes, IndexOutput out) {
        try {
            out.writeInt(bytes.length);
            out.writeBytes(bytes, 0, bytes.length);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    long getIndexRoot(IndexComponent indexComponent) {
        return this.componentMetadatas.get((IndexComponent)indexComponent).root;
    }

    public static class ComponentMetadata {
        public static final String ROOT = "Root";
        public static final String OFFSET = "Offset";
        public static final String LENGTH = "Length";
        public final long root;
        public final long offset;
        public final long length;
        public final Map<String, String> attributes;

        ComponentMetadata(long root, long offset, long length) {
            this.root = root;
            this.offset = offset;
            this.length = length;
            this.attributes = Collections.emptyMap();
        }

        ComponentMetadata(long root, long offset, long length, Map<String, String> attributes) {
            this.root = root;
            this.offset = offset;
            this.length = length;
            this.attributes = attributes;
        }

        ComponentMetadata(DataInput input) throws IOException {
            this.root = input.readLong();
            this.offset = input.readLong();
            this.length = input.readLong();
            int size = input.readInt();
            this.attributes = new HashMap<String, String>(size);
            for (int x = 0; x < size; ++x) {
                String key = input.readString();
                String value = input.readString();
                this.attributes.put(key, value);
            }
        }

        public void write(IndexOutput output) throws IOException {
            output.writeLong(this.root);
            output.writeLong(this.offset);
            output.writeLong(this.length);
            output.writeInt(this.attributes.size());
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                output.writeString(entry.getKey());
                output.writeString(entry.getValue());
            }
        }

        public String toString() {
            return String.format("ComponentMetadata{root=%d, offset=%d, length=%d, attributes=%s}", this.root, this.offset, this.length, this.attributes.toString());
        }

        public Map<String, String> asMap() {
            return ImmutableMap.builder().putAll(this.attributes).put((Object)OFFSET, (Object)Long.toString(this.offset)).put((Object)LENGTH, (Object)Long.toString(this.length)).put((Object)ROOT, (Object)Long.toString(this.root)).build();
        }
    }

    public static class ComponentMetadataMap {
        private final Map<IndexComponent, ComponentMetadata> metas = new EnumMap<IndexComponent, ComponentMetadata>(IndexComponent.class);

        ComponentMetadataMap(DataInput input) throws IOException {
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                this.metas.put(IndexComponent.valueOf(input.readString()), new ComponentMetadata(input));
            }
        }

        public ComponentMetadataMap() {
        }

        public void put(IndexComponent indexComponent, long root, long offset, long length) {
            this.metas.put(indexComponent, new ComponentMetadata(root, offset, length));
        }

        public void put(IndexComponent indexComponent, long root, long offset, long length, Map<String, String> additionalMap) {
            this.metas.put(indexComponent, new ComponentMetadata(root, offset, length, additionalMap));
        }

        private void write(IndexOutput output) throws IOException {
            output.writeInt(this.metas.size());
            for (Map.Entry<IndexComponent, ComponentMetadata> entry : this.metas.entrySet()) {
                output.writeString(entry.getKey().name());
                entry.getValue().write(output);
            }
        }

        public ComponentMetadata get(IndexComponent indexComponent) {
            if (!this.metas.containsKey((Object)indexComponent)) {
                throw new IllegalArgumentException(indexComponent + " ComponentMetadata not found");
            }
            return this.metas.get((Object)indexComponent);
        }

        public Map<String, Map<String, String>> asMap() {
            HashMap<String, Map<String, String>> metaAttributes = new HashMap<String, Map<String, String>>();
            for (Map.Entry<IndexComponent, ComponentMetadata> entry : this.metas.entrySet()) {
                String name = entry.getKey().name();
                ComponentMetadata metadata = entry.getValue();
                Map<String, String> componentAttributes = metadata.asMap();
                assert (!metaAttributes.containsKey(name)) : "Found duplicate index type: " + name;
                metaAttributes.put(name, componentAttributes);
            }
            return metaAttributes;
        }

        public String toString() {
            return "ComponentMetadataMap{metas=" + this.metas + "}";
        }

        public double indexSize() {
            return this.metas.values().stream().mapToLong(meta -> meta.length).sum();
        }
    }
}

