/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractCloudMetadataServiceConnector;
import org.apache.cassandra.locator.Ec2MetadataServiceConnector;
import org.apache.cassandra.locator.Ec2Snitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.ReconnectableSnitchHelper;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.service.StorageService;

public class Ec2MultiRegionSnitch
extends Ec2Snitch {
    @VisibleForTesting
    static final String PUBLIC_IP_QUERY = "/latest/meta-data/public-ipv4";
    @VisibleForTesting
    static final String PRIVATE_IP_QUERY = "/latest/meta-data/local-ipv4";
    private final String localPrivateAddress;

    public Ec2MultiRegionSnitch() throws IOException, ConfigurationException {
        this(new SnitchProperties());
    }

    public Ec2MultiRegionSnitch(SnitchProperties props) throws IOException, ConfigurationException {
        this(Ec2MetadataServiceConnector.create(props));
    }

    Ec2MultiRegionSnitch(AbstractCloudMetadataServiceConnector connector) throws IOException {
        super(connector);
        InetAddress localPublicAddress = InetAddress.getByName(connector.apiCall(PUBLIC_IP_QUERY));
        logger.info("EC2Snitch using publicIP as identifier: {}", (Object)localPublicAddress);
        this.localPrivateAddress = connector.apiCall(PRIVATE_IP_QUERY);
        DatabaseDescriptor.setBroadcastAddress(localPublicAddress);
        if (DatabaseDescriptor.getBroadcastRpcAddress() == null) {
            logger.info("broadcast_rpc_address unset, broadcasting public IP as rpc_address: {}", (Object)localPublicAddress);
            DatabaseDescriptor.setBroadcastRpcAddress(localPublicAddress);
        }
    }

    @Override
    public void gossiperStarting() {
        InetAddressAndPort address;
        super.gossiperStarting();
        try {
            address = InetAddressAndPort.getByName(this.localPrivateAddress);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        Gossiper.instance.addLocalApplicationState(ApplicationState.INTERNAL_ADDRESS_AND_PORT, StorageService.instance.valueFactory.internalAddressAndPort(address));
        Gossiper.instance.addLocalApplicationState(ApplicationState.INTERNAL_IP, StorageService.instance.valueFactory.internalIP(address.getAddress()));
        Gossiper.instance.register(new ReconnectableSnitchHelper(this, this.getLocalDatacenter(), true));
    }
}

