/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import com.google.protobuf.GeneratedMessageV3;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.protocol.message.Message;
import org.apache.celeborn.common.rpc.RpcSource;
import org.apache.celeborn.common.rpc.RpcSource$;
import org.apache.celeborn.common.rpc.netty.InboxMessage;
import org.apache.celeborn.common.rpc.netty.OneWayMessage;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier$;
import org.apache.celeborn.common.rpc.netty.RpcMessage;
import org.apache.celeborn.common.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf!B\u0012%\u0001!r\u0003\u0002C\u001e\u0001\u0005\u000b\u0007I\u0011A\u001f\t\u0011%\u0003!\u0011!Q\u0001\nyB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\")A\u000b\u0001C\u0001+\"9!\f\u0001b\u0001\n\u0003Y\u0006B\u00029\u0001A\u0003%A\fC\u0004r\u0001\t\u0007I\u0011\u0002:\t\re\u0004\u0001\u0015!\u0003t\u0011\u001dQ\bA1A\u0005\nmDaa \u0001!\u0002\u0013a\b\u0002CA\u0001\u0001\t\u0007I\u0011B>\t\u000f\u0005\r\u0001\u0001)A\u0005y\"A\u0011Q\u0001\u0001C\u0002\u0013%1\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011\u0002?\t\u0011\u0005%\u0001A1A\u0005\nIDq!a\u0003\u0001A\u0003%1\u000f\u0003\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003s\u0011\u001d\ty\u0001\u0001Q\u0001\nMD\u0011\"!\u0005\u0001\u0005\u0004%i!a\u0005\t\u0011\u0005m\u0001\u0001)A\u0007\u0003+A\u0011\"!\b\u0001\u0005\u0004%i!a\b\t\u0011\u0005m\u0002\u0001)A\u0007\u0003CA1\"!\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002@!Y\u0011q\t\u0001A\u0002\u0003\u0007I\u0011BA%\u0011-\t)\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0011\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003[\u0002A\u0011AA1\u0011\u001d\ty\u0007\u0001C\u0005\u0003cBq!a#\u0001\t\u0003\ti\tC\u0004\u0002\u001c\u0002!\t!!(\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002b\t\t\"\u000b]2NKR\u0014\u0018nY:Ue\u0006\u001c7.\u001a:\u000b\u0005\u00152\u0013a\u0001:qG*\u0011q\u0005K\u0001\u0007G>lWn\u001c8\u000b\u0005%R\u0013\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\n\u0004\u0001=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g\r\u0005\u00027s5\tqG\u0003\u00029M\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002;o\t9Aj\\4hS:<\u0017\u0001\u00028b[\u0016\u001c\u0001!F\u0001?!\tydI\u0004\u0002A\tB\u0011\u0011)M\u0007\u0002\u0005*\u00111\tP\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015\u000b\u0014A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!R\u0019\u0002\u000b9\fW.\u001a\u0011\u0002\u0013I\u00048mU8ve\u000e,\u0007C\u0001'N\u001b\u0005!\u0013B\u0001(%\u0005%\u0011\u0006oY*pkJ\u001cW-\u0001\u0003d_:4\u0007CA)S\u001b\u00051\u0013BA*'\u00051\u0019U\r\\3c_Jt7i\u001c8g\u0003\u0019a\u0014N\\5u}Q!ak\u0016-Z!\ta\u0005\u0001C\u0003<\u000b\u0001\u0007a\bC\u0003K\u000b\u0001\u00071\nC\u0003P\u000b\u0001\u0007\u0001+\u0001\u0007iSN$xn\u001a:b[6\u000b\u0007/F\u0001]!\u0011iFM\u00104\u000e\u0003yS!a\u00181\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002bE\u0006!Q\u000f^5m\u0015\u0005\u0019\u0017\u0001\u00026bm\u0006L!!\u001a0\u0003\u001b\r{gnY;se\u0016tG/T1q!\t9g.D\u0001i\u0015\tI'.A\u0004nKR\u0014\u0018nY:\u000b\u0005-d\u0017\u0001C2pI\u0006D\u0017\r\\3\u000b\u00035\f1aY8n\u0013\ty\u0007NA\u0005ISN$xn\u001a:b[\u0006i\u0001.[:u_\u001e\u0014\u0018-\\'ba\u0002\na\"\\1y#V,W/\u001a'f]\u001e$\b.F\u0001t!\t!x/D\u0001v\u0015\t1h,\u0001\u0004bi>l\u0017nY\u0005\u0003qV\u0014!\"\u0011;p[&\u001cGj\u001c8h\u0003=i\u0017\r_)vKV,G*\u001a8hi\"\u0004\u0013\u0001E:m_^\u0014\u0006o\u0019+ie\u0016\u001c\bn\u001c7e+\u0005a\bC\u0001\u0019~\u0013\tq\u0018G\u0001\u0003M_:<\u0017!E:m_^\u0014\u0006o\u0019+ie\u0016\u001c\bn\u001c7eA\u0005y1\u000f\\8x%B\u001c\u0017J\u001c;feZ\fG.\u0001\ttY><(\u000b]2J]R,'O^1mA\u0005y!\u000f]2Ek6\u0004\u0018J\u001c;feZ\fG.\u0001\tsa\u000e$U/\u001c9J]R,'O^1mA\u0005aA.Y:u\tVl\u0007\u000fV5nK\u0006iA.Y:u\tVl\u0007\u000fV5nK\u0002\nq\u0002\\1tiNcwn\u001e'pORKW.Z\u0001\u0011Y\u0006\u001cHo\u00157po2{w\rV5nK\u0002\nA\"^:f\u0011&\u001cHo\\4sC6,\"!!\u0006\u0011\u0007A\n9\"C\u0002\u0002\u001aE\u0012qAQ8pY\u0016\fg.A\u0007vg\u0016D\u0015n\u001d;pOJ\fW\u000eI\u0001\u000b\u001d\u0006kUi\u0018'B\u0005\u0016cUCAA\u0011!\u001d\t\u0019#!\f\u00022yj!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\nS6lW\u000f^1cY\u0016T1!a\u000b2\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\t)CA\u0002NCB\u0004B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o\u0011\u0017\u0001\u00027b]\u001eL1aRA\u001b\u0003-q\u0015)T#`\u0019\u0006\u0013U\t\u0014\u0011\u0002\u001fE,X-^3MK:<G\u000f\u001b$v]\u000e,\"!!\u0011\u0011\tA\n\u0019\u0005`\u0005\u0004\u0003\u000b\n$!\u0003$v]\u000e$\u0018n\u001c81\u0003M\tX/Z;f\u0019\u0016tw\r\u001e5Gk:\u001cw\fJ3r)\u0011\tY%!\u0015\u0011\u0007A\ni%C\u0002\u0002PE\u0012A!\u00168ji\"I\u00111K\r\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0004q\u0012\n\u0014\u0001E9vKV,G*\u001a8hi\"4UO\\2!\u0003\u0011Ig.\u001b;\u0015\t\u0005-\u00131\f\u0005\b\u0003;Z\u0002\u0019AA!\u0003)aWM\\4uQ\u001a+hnY\u0001\u0006G2|7/\u001a\u000b\u0003\u0003\u0017\nq\"\u001e9eCR,\u0007*[:u_\u001e\u0014\u0018-\u001c\u000b\u0007\u0003\u0017\n9'!\u001b\t\u000bmj\u0002\u0019\u0001 \t\r\u0005-T\u00041\u0001}\u0003\u00151\u0018\r\\;f\u0003=)\b\u000fZ1uK6\u000b\u0007\u0010T3oORD\u0017A\u00037pONcwn\u001e*qGRA\u00111JA:\u0003\u0007\u000b9\tC\u0004\u0002v}\u0001\r!a\u001e\u0002\u000f5,7o]1hKB!\u0011\u0011PA@\u001b\t\tYHC\u0002\u0002~\u0011\nQA\\3uifLA!!!\u0002|\ta\u0011J\u001c2pq6+7o]1hK\"1\u0011QQ\u0010A\u0002q\f\u0011\"];fk\u0016$\u0016.\\3\t\r\u0005%u\u00041\u0001}\u0003-\u0001(o\\2fgN$\u0016.\\3\u0002\rI,7m\u001c:e)!\tY%a$\u0002\u0018\u0006e\u0005bBA;A\u0001\u0007\u0011\u0011\u0013\t\u0004a\u0005M\u0015bAAKc\t\u0019\u0011I\\=\t\r\u0005\u0015\u0005\u00051\u0001}\u0011\u0019\tI\t\ta\u0001y\u00061Q\u000f\u001d3bi\u0016$B!a\u0013\u0002 \"9\u0011QO\u0011A\u0002\u0005]\u0014\u0001\u00023v[B\u0004")
public class RpcMetricsTracker
implements Logging {
    private final String name;
    private final RpcSource rpcSource;
    private final ConcurrentMap<String, Histogram> histogramMap;
    private final AtomicLong maxQueueLength;
    private final long slowRpcThreshold;
    private final long slowRpcInterval;
    private final long rpcDumpInterval;
    private final AtomicLong lastDumpTime;
    private final AtomicLong lastSlowLogTime;
    private final boolean useHistogram;
    private final Map<String, String> NAME_LABEL;
    private Function0<Object> queueLengthFunc;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        RpcMetricsTracker rpcMetricsTracker = this;
        synchronized (rpcMetricsTracker) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public String name() {
        return this.name;
    }

    public ConcurrentMap<String, Histogram> histogramMap() {
        return this.histogramMap;
    }

    private AtomicLong maxQueueLength() {
        return this.maxQueueLength;
    }

    private long slowRpcThreshold() {
        return this.slowRpcThreshold;
    }

    private long slowRpcInterval() {
        return this.slowRpcInterval;
    }

    private long rpcDumpInterval() {
        return this.rpcDumpInterval;
    }

    private AtomicLong lastDumpTime() {
        return this.lastDumpTime;
    }

    private AtomicLong lastSlowLogTime() {
        return this.lastSlowLogTime;
    }

    private final boolean useHistogram() {
        return this.useHistogram;
    }

    private final Map<String, String> NAME_LABEL() {
        return this.NAME_LABEL;
    }

    private Function0<Object> queueLengthFunc() {
        return this.queueLengthFunc;
    }

    private void queueLengthFunc_$eq(Function0<Object> x$1) {
        this.queueLengthFunc = x$1;
    }

    public void init(Function0<Object> lengthFunc) {
        this.queueLengthFunc_$eq(lengthFunc);
        if (this.name() != null) {
            this.rpcSource.addGauge(RpcSource$.MODULE$.QUEUE_LENGTH(), this.NAME_LABEL(), this.queueLengthFunc());
            this.rpcSource.addTimer(RpcSource$.MODULE$.QUEUE_TIME(), this.NAME_LABEL());
            this.rpcSource.addTimer(RpcSource$.MODULE$.PROCESS_TIME(), this.NAME_LABEL());
            return;
        }
    }

    public void close() {
        this.histogramMap().clear();
        this.rpcSource.removeGauge(RpcSource$.MODULE$.QUEUE_LENGTH());
        this.rpcSource.removeTimer(RpcSource$.MODULE$.QUEUE_TIME());
        this.rpcSource.removeTimer(RpcSource$.MODULE$.PROCESS_TIME());
    }

    public void updateHistogram(String name, long value) {
        this.histogramMap().putIfAbsent(name, new Histogram((Reservoir)new UniformReservoir()));
        Histogram histogram = (Histogram)this.histogramMap().get(name);
        histogram.update(value);
    }

    public void updateMaxLength() {
        long len = this.queueLengthFunc().apply$mcJ$sp();
        if (len > this.maxQueueLength().get()) {
            this.maxQueueLength().set(len);
            return;
        }
    }

    private void logSlowRpc(InboxMessage message, long queueTime, long processTime) {
        if (queueTime + processTime > this.slowRpcThreshold()) {
            long lastLogTime = this.lastSlowLogTime().get();
            if (this.slowRpcInterval() < 0L || System.currentTimeMillis() - lastLogTime > this.slowRpcInterval() && this.lastSlowLogTime().compareAndSet(lastLogTime, System.currentTimeMillis())) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("slow rpc detected: currentQueueSize = ").append(this.queueLengthFunc().apply$mcJ$sp()).append(", queueTime=").append(queueTime).append("(ns) processTime=").append(processTime).append("(ns) message=").append(message).toString());
            }
            long lastTime = this.lastDumpTime().get();
            if (this.useHistogram() && System.currentTimeMillis() - lastTime > this.rpcDumpInterval() && this.lastDumpTime().compareAndSet(lastTime, System.currentTimeMillis())) {
                this.dump();
                return;
            }
            return;
        }
    }

    public void record(Object message, long queueTime, long processTime) {
        String msgName = RpcMetricsTracker.messageName$1(message);
        if (this.useHistogram()) {
            this.updateHistogram(RpcSource$.MODULE$.QUEUE_TIME(), queueTime);
            this.updateHistogram(RpcSource$.MODULE$.PROCESS_TIME(), processTime);
            this.updateHistogram(msgName, processTime);
            return;
        }
        this.rpcSource.updateTimer(RpcSource$.MODULE$.QUEUE_TIME(), queueTime, this.NAME_LABEL());
        this.rpcSource.updateTimer(RpcSource$.MODULE$.PROCESS_TIME(), processTime, this.NAME_LABEL());
        this.rpcSource.updateTimer(msgName, processTime);
    }

    public void update(InboxMessage message) {
        InboxMessage inboxMessage = message;
        if (inboxMessage instanceof RpcMessage) {
            RpcMessage rpcMessage = (RpcMessage)inboxMessage;
            Object content = rpcMessage.content();
            long queueTime = rpcMessage.dequeueTime() - rpcMessage.enqueueTime();
            long processTime = rpcMessage.endProcessTime() - rpcMessage.dequeueTime();
            this.record(content, queueTime, processTime);
            this.logSlowRpc(message, queueTime, processTime);
            return;
        }
        if (inboxMessage instanceof OneWayMessage) {
            OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
            Object content = oneWayMessage.content();
            long queueTime = oneWayMessage.dequeueTime() - oneWayMessage.enqueueTime();
            long processTime = oneWayMessage.endProcessTime() - oneWayMessage.dequeueTime();
            this.record(content, queueTime, processTime);
            this.logSlowRpc(message, queueTime, processTime);
            return;
        }
    }

    public void dump() {
        if (!this.useHistogram()) {
            return;
        }
        scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder();
        builder.append(new StringBuilder(35).append("RPC statistics for ").append(this.name()).append(" (time unit: ns)").toString()).append("\n");
        builder.append(new StringBuilder(21).append("current queue size = ").append(this.queueLengthFunc().apply$mcJ$sp()).toString()).append("\n");
        builder.append(new StringBuilder(19).append("max queue length = ").append(this.maxQueueLength().get()).toString()).append("\n");
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.histogramMap().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            Histogram histogram = (Histogram)entry.getValue();
            Snapshot snapshot = histogram.getSnapshot();
            builder.append(new StringBuilder(28).append("histogram for ").append(this.name()).append(" RPC metrics: ").toString()).append((String)entry.getKey()).append("\n");
            return builder.append("count: ").append(histogram.getCount()).append("\n").append("min: ").append(snapshot.getMin()).append("\n").append("mean: ").append(snapshot.getMean()).append("\n").append("p50: ").append(snapshot.getMedian()).append("\n").append("p75: ").append(snapshot.get75thPercentile()).append("\n").append("p95: ").append(snapshot.get95thPercentile()).append("\n").append("p99: ").append(snapshot.get99thPercentile()).append("\n").append("max: ").append(snapshot.getMax()).append("\n");
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> builder.toString());
    }

    private static final String messageName$1(Object message) {
        Object object = message;
        if (object instanceof Message) {
            Message message2 = (Message)object;
            return message2.getClass().toString();
        }
        if (object instanceof GeneratedMessageV3) {
            GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)object;
            return generatedMessageV3.getDescriptorForType().getFullName();
        }
        if (object instanceof RpcEndpointVerifier.CheckExistence) {
            return "CheckExistence";
        }
        return "unknown";
    }

    /*
     * Unable to fully structure code
     */
    public RpcMetricsTracker(String name, RpcSource rpcSource, CelebornConf conf) {
        this.name = name;
        this.rpcSource = rpcSource;
        super();
        Logging.$init$(this);
        this.histogramMap = JavaUtils.newConcurrentHashMap();
        this.maxQueueLength = new AtomicLong(0L);
        this.slowRpcThreshold = conf.rpcSlowThresholdNs();
        this.slowRpcInterval = conf.rpcSlowIntervalMs();
        this.rpcDumpInterval = conf.rpcDumpIntervalMs();
        this.lastDumpTime = new AtomicLong(0L);
        this.lastSlowLogTime = new AtomicLong(0L);
        v0 = name;
        var4_4 = RpcNameConstants.LIFECYCLE_MANAGER_EP;
        if (!(v0 == null ? var4_4 != null : v0.equals(var4_4) == false)) ** GOTO lbl-1000
        v1 = name;
        var5_5 = RpcEndpointVerifier$.MODULE$.NAME();
        if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        this.useHistogram = v2;
        this.NAME_LABEL = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)}));
    }
}

