/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiFunction;
import org.apache.celeborn.client.ShuffleClientImpl;
import org.apache.celeborn.client.read.CelebornInputStream;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.util.CelebornHadoopUtils;
import org.apache.celeborn.common.util.ExceptionMaker;
import org.apache.celeborn.common.write.LocationPushFailedBatches;
import org.apache.celeborn.common.write.PushState;
import org.apache.celeborn.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public abstract class ShuffleClient {
    private static Logger logger = LoggerFactory.getLogger(ShuffleClient.class);
    private static volatile ShuffleClient _instance;
    private static volatile boolean initialized;
    private static volatile Map<StorageInfo.Type, FileSystem> hadoopFs;
    private static LongAdder totalReadCounter;
    private static LongAdder localShuffleReadCounter;
    private static volatile Optional<BiFunction<Integer, byte[], ControlMessages.GetReducerFileGroupResponse>> deserializeReducerFileGroupResponseFunction;

    public static void reset() {
        _instance = null;
        initialized = false;
        hadoopFs = null;
    }

    protected ShuffleClient() {
    }

    public static ShuffleClient get(String appUniqueId, String driverHost, int port, CelebornConf conf, UserIdentifier userIdentifier) {
        return ShuffleClient.get(appUniqueId, driverHost, port, conf, userIdentifier, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShuffleClient get(String appUniqueId, String driverHost, int port, CelebornConf conf, UserIdentifier userIdentifier, byte[] extension) {
        if (null != _instance && initialized) return _instance;
        Class<ShuffleClient> clazz = ShuffleClient.class;
        synchronized (ShuffleClient.class) {
            if (null == _instance) {
                _instance = new ShuffleClientImpl(appUniqueId, conf, userIdentifier);
                _instance.setupLifecycleManagerRef(driverHost, port);
                _instance.setExtension(extension);
                initialized = true;
            } else {
                if (initialized) return _instance;
                _instance.shutdown();
                _instance = new ShuffleClientImpl(appUniqueId, conf, userIdentifier);
                _instance.setupLifecycleManagerRef(driverHost, port);
                _instance.setExtension(extension);
                initialized = true;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<StorageInfo.Type, FileSystem> getHadoopFs(CelebornConf conf) {
        if (null != hadoopFs) return hadoopFs;
        Class<ShuffleClient> clazz = ShuffleClient.class;
        synchronized (ShuffleClient.class) {
            if (null != hadoopFs) return hadoopFs;
            try {
                hadoopFs = CelebornHadoopUtils.getHadoopFS(conf);
            }
            catch (Exception e) {
                logger.error("Celeborn initialize DFS failed.", (Throwable)e);
            }
            return hadoopFs;
        }
    }

    public static void incrementLocalReadCounter() {
        localShuffleReadCounter.increment();
        totalReadCounter.increment();
    }

    public static void incrementTotalReadCounter() {
        totalReadCounter.increment();
    }

    public static void printReadStats(Logger logger) {
        long totalReadCount = totalReadCounter.longValue();
        long localReadCount = localShuffleReadCounter.longValue();
        logger.info("Current client read {}/{} (local/total) partitions, local read ratio {}", new Object[]{localReadCount, totalReadCount, String.format("%.2f", (double)localReadCount * 1.0 / (double)totalReadCount * 100.0)});
    }

    public abstract void setupLifecycleManagerRef(String var1, int var2);

    public abstract void setupLifecycleManagerRef(RpcEndpointRef var1);

    public abstract void setExtension(byte[] var1);

    public abstract int pushData(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, int var8, int var9) throws IOException;

    public abstract void prepareForMergeData(int var1, int var2, int var3) throws IOException;

    public abstract int mergeData(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, int var8, int var9) throws IOException;

    public abstract void pushMergedData(int var1, int var2, int var3) throws IOException;

    public abstract void mapperEnd(int var1, int var2, int var3, int var4, int var5) throws IOException;

    public abstract void readReducerPartitionEnd(int var1, int var2, int var3, int var4, int var5, long var6) throws IOException;

    public abstract void mapPartitionMapperEnd(int var1, int var2, int var3, int var4, int var5, int var6) throws IOException;

    public abstract void cleanup(int var1, int var2, int var3);

    public abstract ShuffleClientImpl.ReduceFileGroups updateFileGroup(int var1, int var2) throws CelebornIOException;

    public abstract boolean isShuffleStageEnd(int var1) throws Exception;

    public CelebornInputStream readPartition(int shuffleId, int partitionId, int attemptNumber, long taskId, int startMapIndex, int endMapIndex, MetricsCallback metricsCallback) throws IOException {
        return this.readPartition(shuffleId, shuffleId, partitionId, attemptNumber, taskId, startMapIndex, endMapIndex, null, null, null, null, null, null, metricsCallback, true);
    }

    public abstract CelebornInputStream readPartition(int var1, int var2, int var3, int var4, long var5, int var7, int var8, ExceptionMaker var9, ArrayList<PartitionLocation> var10, ArrayList<PbStreamHandler> var11, Map<String, LocationPushFailedBatches> var12, Map<String, Pair<Integer, Integer>> var13, int[] var14, MetricsCallback var15, boolean var16) throws IOException;

    public abstract boolean cleanupShuffle(int var1);

    public abstract void shutdown();

    public abstract PartitionLocation registerMapPartitionTask(int var1, int var2, int var3, int var4, int var5) throws IOException;

    public abstract ConcurrentHashMap<Integer, PartitionLocation> getPartitionLocation(int var1, int var2, int var3) throws CelebornIOException;

    public abstract PushState getPushState(String var1);

    public abstract Tuple2<Integer, Boolean> getShuffleId(int var1, String var2, boolean var3, boolean var4);

    public abstract boolean reportShuffleFetchFailure(int var1, int var2, long var3);

    public abstract boolean reportBarrierTaskFailure(int var1, String var2);

    public abstract TransportClientFactory getDataClientFactory();

    public abstract void excludeFailedFetchLocation(String var1, Exception var2);

    public static void registerDeserializeReducerFileGroupResponseFunction(BiFunction<Integer, byte[], ControlMessages.GetReducerFileGroupResponse> function) {
        if (!deserializeReducerFileGroupResponseFunction.isPresent()) {
            deserializeReducerFileGroupResponseFunction = Optional.ofNullable(function);
        }
    }

    public static ControlMessages.GetReducerFileGroupResponse deserializeReducerFileGroupResponse(int shuffleId, byte[] bytes) {
        if (!deserializeReducerFileGroupResponseFunction.isPresent()) {
            logger.warn("DeserializeReducerFileGroupResponseFunction is not registered.");
            return null;
        }
        return deserializeReducerFileGroupResponseFunction.get().apply(shuffleId, bytes);
    }

    static {
        initialized = false;
        totalReadCounter = new LongAdder();
        localShuffleReadCounter = new LongAdder();
        deserializeReducerFileGroupResponseFunction = Optional.empty();
    }
}

