/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.protocol;

import java.util.Objects;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.plugin.flink.protocol.ReadData;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;

public class SubPartitionReadData
extends ReadData {
    private final int subPartitionId;

    public SubPartitionReadData(long streamId, int subPartitionId) {
        super(streamId);
        this.subPartitionId = subPartitionId;
    }

    @Override
    public int encodedLength() {
        return super.encodedLength() + 4;
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        buf.writeInt(this.subPartitionId);
    }

    public int getSubPartitionId() {
        return this.subPartitionId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.SUBPARTITION_READ_DATA;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubPartitionReadData readData = (SubPartitionReadData)o;
        return this.streamId == readData.getStreamId() && this.subPartitionId == readData.getSubPartitionId() && Objects.equals(this.flinkBuffer, readData.flinkBuffer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.streamId, this.subPartitionId, this.flinkBuffer);
    }

    @Override
    public String toString() {
        return "SubpartitionReadData{streamId=" + this.streamId + ", subPartitionId=" + this.subPartitionId + ", flinkBuffer=" + this.flinkBuffer + '}';
    }
}

