/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.compress;

import com.github.luben.zstd.Zstd;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.celeborn.client.compress.Compressor;
import org.apache.celeborn.client.compress.ZstdTrait;

public class ZstdCompressor
extends ZstdTrait
implements Compressor {
    private final int compressionLevel;
    private final Checksum checksum;
    private byte[] compressedBuffer;
    private int compressedTotalSize;

    public ZstdCompressor(int blockSize, int level) {
        this.compressionLevel = level;
        this.checksum = new CRC32();
        this.initCompressBuffer(blockSize);
    }

    @Override
    public void initCompressBuffer(int maxDestLength) {
        int compressedBlockSize = HEADER_LENGTH + maxDestLength;
        this.compressedBuffer = new byte[compressedBlockSize];
        System.arraycopy(MAGIC, 0, this.compressedBuffer, 0, MAGIC_LENGTH);
    }

    @Override
    public void compress(byte[] data, int offset, int length) {
        int compressMethod;
        int compressedLength;
        this.checksum.reset();
        this.checksum.update(data, offset, length);
        int check = (int)this.checksum.getValue();
        int maxDestLength = (int)Zstd.compressBound((long)length);
        if (this.compressedBuffer.length - HEADER_LENGTH < maxDestLength) {
            this.initCompressBuffer(maxDestLength);
        }
        if ((compressedLength = (int)Zstd.compressByteArray((byte[])this.compressedBuffer, (int)HEADER_LENGTH, (int)(maxDestLength - HEADER_LENGTH), (byte[])data, (int)offset, (int)length, (int)this.compressionLevel)) >= length) {
            compressMethod = 16;
            compressedLength = length;
            System.arraycopy(data, offset, this.compressedBuffer, HEADER_LENGTH, length);
        } else {
            compressMethod = 48;
        }
        this.compressedBuffer[ZstdCompressor.MAGIC_LENGTH] = (byte)compressMethod;
        this.writeIntLE(compressedLength, this.compressedBuffer, MAGIC_LENGTH + 1);
        this.writeIntLE(length, this.compressedBuffer, MAGIC_LENGTH + 5);
        this.writeIntLE(check, this.compressedBuffer, MAGIC_LENGTH + 9);
        this.compressedTotalSize = HEADER_LENGTH + compressedLength;
    }

    @Override
    public int getCompressedTotalSize() {
        return this.compressedTotalSize;
    }

    @Override
    public byte[] getCompressedBuffer() {
        return this.compressedBuffer;
    }
}

