/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.utils;

import java.util.Map;
import java.util.Set;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;

public class FlinkUtils {
    private static final JobID ZERO_JOB_ID = new JobID(0L, 0L);
    public static final Set<String> pluginConfNames = ImmutableSet.of("remote-shuffle.job.concurrent-readings-per-gate", "remote-shuffle.job.memory-per-partition", "remote-shuffle.job.memory-per-gate", "remote-shuffle.job.support-floating-buffer-per-input-gate", "remote-shuffle.job.enable-data-compression", "remote-shuffle.job.support-floating-buffer-per-output-gate", new String[]{"remote-shuffle.job.compression.codec"});

    public static CelebornConf toCelebornConf(Configuration configuration) {
        if (Boolean.parseBoolean(configuration.getString(CelebornConf.CLIENT_PUSH_REPLICATE_ENABLED().key(), CelebornConf.CLIENT_PUSH_REPLICATE_ENABLED().defaultValueString()))) {
            throw new IllegalArgumentException(String.format("Flink does not support replicate shuffle data. Please check the config %s.", CelebornConf.CLIENT_PUSH_REPLICATE_ENABLED().key()));
        }
        CelebornConf tmpCelebornConf = new CelebornConf();
        Map confMap = configuration.toMap();
        for (Map.Entry entry : confMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("celeborn.") && !pluginConfNames.contains(key)) continue;
            tmpCelebornConf.set(key, (String)entry.getValue());
        }
        return tmpCelebornConf.setIfMissing(CelebornConf.CLIENT_CHECKED_USE_ALLOCATED_WORKERS(), Boolean.valueOf(true));
    }

    public static String toCelebornAppId(long lifecycleManagerTimestamp, JobID jobID) {
        if (!ZERO_JOB_ID.equals((Object)jobID)) {
            return lifecycleManagerTimestamp + "-" + jobID.toString();
        }
        return lifecycleManagerTimestamp + "-" + JobID.generate();
    }

    public static String toShuffleId(JobID jobID, IntermediateDataSetID dataSetID) {
        return jobID.toString() + "-" + dataSetID.toString();
    }

    public static String toAttemptId(ExecutionAttemptID attemptID) {
        return attemptID.toString();
    }
}

