/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.http.api.v1;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.rest.v1.model.HandleResponse;
import org.apache.celeborn.rest.v1.model.RatisElectionTransferRequest;
import org.apache.celeborn.rest.v1.model.RatisLocalRaftMetaConfRequest;
import org.apache.celeborn.rest.v1.model.RatisPeer;
import org.apache.celeborn.rest.v1.model.RatisPeerAddRequest;
import org.apache.celeborn.rest.v1.model.RatisPeerRemoveRequest;
import org.apache.celeborn.rest.v1.model.RatisPeerSetPriorityRequest;
import org.apache.celeborn.server.common.HttpService;
import org.apache.celeborn.server.common.http.api.ApiRequestContext;
import org.apache.celeborn.service.deploy.master.Master;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.HAMasterMetaManager;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.HARaftServer;
import org.apache.celeborn.service.deploy.master.http.api.MasterHttpResourceUtils$;
import org.apache.commons.io.IOUtils;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Tag(name="Ratis")
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\rua\u0001B\n\u0015\u0001\u001dBQa\u0010\u0001\u0005\u0002\u0001CQa\u0007\u0001\u0005\n\rCQ\u0001\u0013\u0001\u0005\n%CQA\u0015\u0001\u0005\u0002MCq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002l\u0001!\t!a\u0015\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002T!9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003?\u0004A\u0011AAq\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003'BqA!\u0007\u0001\t\u0003\u0011Y\u0002C\u0004\u0003P\u0001!\tA!\u0015\t\u000f\t5\u0004\u0001\"\u0003\u0003p!9!1\u0012\u0001\u0005\n\t5\u0005b\u0002BV\u0001\u0011%!Q\u0016\u0005\b\u0005#\u0004A\u0011\u0002Bj\u0011\u001d\u0011)\u000e\u0001C\u0005\u0005/\u0014QBU1uSN\u0014Vm]8ve\u000e,'BA\u000b\u0017\u0003\t1\u0018G\u0003\u0002\u00181\u0005\u0019\u0011\r]5\u000b\u0005eQ\u0012\u0001\u00025uiBT!a\u0007\u000f\u0002\r5\f7\u000f^3s\u0015\tib$\u0001\u0004eKBdw.\u001f\u0006\u0003?\u0001\nqa]3sm&\u001cWM\u0003\u0002\"E\u0005A1-\u001a7fE>\u0014hN\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0005\u0001!r\u0003\b\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VM\u001a\t\u0003_Yj\u0011\u0001\r\u0006\u0003/ER!!\u0007\u001a\u000b\u0005M\"\u0014AB2p[6|gN\u0003\u00026A\u000511/\u001a:wKJL!a\u000e\u0019\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0002:{5\t!H\u0003\u0002<y\u0005A\u0011N\u001c;fe:\fGN\u0003\u00024A%\u0011aH\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\t\u0005\u0002C\u00015\tA#F\u0001E!\t)e)D\u0001\u001b\u0013\t9%D\u0001\u0004NCN$XM]\u0001\fe\u0006$\u0018n]*feZ,'/F\u0001K!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0002iC*\u0011qJG\u0001\fG2,8\u000f^3s[\u0016$\u0018-\u0003\u0002R\u0019\na\u0001*\u0011*bMR\u001cVM\u001d<fe\u0006\u0001R\r\\3di&|g\u000e\u0016:b]N4WM\u001d\u000b\u0003)v\u0003\"!V.\u000e\u0003YS!a\u0016-\u0002\u000b5|G-\u001a7\u000b\u0005UI&B\u0001.!\u0003\u0011\u0011Xm\u001d;\n\u0005q3&A\u0004%b]\u0012dWMU3ta>t7/\u001a\u0005\u0006=\u0012\u0001\raX\u0001\be\u0016\fX/Z:u!\t)\u0006-\u0003\u0002b-\na\"+\u0019;jg\u0016cWm\u0019;j_:$&/\u00198tM\u0016\u0014(+Z9vKN$\b\u0006\u0002\u0003d[:\u0004\"\u0001Z6\u000e\u0003\u0015T!AZ4\u0002\u0005I\u001c(B\u00015j\u0003\t98OC\u0001k\u0003\u0015Q\u0017M^1y\u0013\taWM\u0001\u0005Qe>$WoY3t\u0003\u00151\u0018\r\\;fY\u0005y\u0017%\u00019\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007\u0006\u0002\u0003s[V\u0004\"\u0001Z:\n\u0005Q,'\u0001\u0002)bi\"\f\u0013A^\u0001\u0013_\u0015dWm\u0019;j_:|CO]1og\u001a,'\u000f\u000b\u0002\u0005qB\u0011A-_\u0005\u0003u\u0016\u0014A\u0001U(T)\"RA\u0001`A\r\u00037\ty\"!\t\u0011\u0007u\f)\"D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\ne\u0016\u001c\bo\u001c8tKNTA!a\u0001\u0002\u0006\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\t9!!\u0003\u0002\u0007=\f7O\u0003\u0003\u0002\f\u00055\u0011A\u0001<4\u0015\u0011\ty!!\u0005\u0002\u000fM<\u0018mZ4fe*\u0011\u00111C\u0001\u0003S>L1!a\u0006\u007f\u0005-\t\u0005/\u001b*fgB|gn]3\u0002\u0019I,7\u000f]8og\u0016\u001cu\u000eZ3\"\u0005\u0005u\u0011a\u0001\u001a1a\u000591m\u001c8uK:$HFAA\u0012W%\t)#!\rp\u0003g\t)\u0004\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\u0011\tY#!\u0001\u0002\u000b5,G-[1\n\t\u0005=\u0012\u0011\u0006\u0002\b\u0007>tG/\u001a8u\u0003%iW\rZ5b)f\u0004X-\u0001\u0004tG\",W.Y\u0016\u0007\u0003o\ti$a\u0010\u0011\t\u0005\u001d\u0012\u0011H\u0005\u0005\u0003w\tIC\u0001\u0004TG\",W.Y\u0001\u000fS6\u0004H.Z7f]R\fG/[8oG\u0005!\u0006f\u0002\u0003\u0002D\u0005-\u0013Q\n\t\u0005\u0003\u000b\n9%\u0004\u0002\u0002\u0002%!\u0011\u0011JA\u0001\u0005%y\u0005/\u001a:bi&|g.A\u0006eKN\u001c'/\u001b9uS>t\u0017EAA(\u0003I\"&/\u00198tM\u0016\u0014\b\u0005\u001e5fA\u001d\u0014x.\u001e9!Y\u0016\fG-\u001a:!i>\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u00043/\u001a:wKJt\u0013\u0001E3mK\u000e$\u0018n\u001c8Ti\u0016\u0004Hi\\<o)\u0005!\u0006&B\u0003d[\u0006]C&A8)\u000b\u0015\u0011X.a\u0017\"\u0005\u0005u\u0013aE\u0018fY\u0016\u001cG/[8o_M$X\r]0e_^t\u0007FA\u0003yQ))A0!\u0007\u0002\u001c\u0005}\u00111\r\u0017\u0003\u0003GAs!BA\"\u0003\u0017\n9'\t\u0002\u0002j\u0005yS*Y6fAQDW\rI4s_V\u0004\b\u0005\\3bI\u0016\u0014\be\u001d;fa\u0002\"wn\u001e8!SR\u001c\b\u0005\\3bI\u0016\u00148\u000f[5q]\u0005iQ\r\\3di&|g\u000eU1vg\u0016DSAB2n\u0003_b\u0013a\u001c\u0015\u0006\rIl\u00171O\u0011\u0003\u0003k\nqbL3mK\u000e$\u0018n\u001c80a\u0006,8/\u001a\u0015\u0003\raD#B\u0002?\u0002\u001a\u0005m\u0011qDA>Y\t\t\u0019\u0003K\u0004\u0007\u0003\u0007\nY%a \"\u0005\u0005\u0005\u0015\u0001\u001b)bkN,\u0007\u0005\\3bI\u0016\u0014\b%\u001a7fGRLwN\u001c\u0011bi\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!g\u0016\u0014h/\u001a:/AQCWM\u001c\u0017!i\",\u0007eY;se\u0016tG\u000fI:feZ,'\u000fI<pk2$\u0007E\\8uAM$\u0018M\u001d;!C\u0002bW-\u00193fe\u0002*G.Z2uS>tg&\u0001\bfY\u0016\u001cG/[8o%\u0016\u001cX/\\3)\u000b\u001d\u0019W.a\"-\u0003=DSa\u0002:n\u0003\u0017\u000b#!!$\u0002!=*G.Z2uS>twF]3tk6,\u0007FA\u0004yQ)9A0!\u0007\u0002\u001c\u0005}\u00111\u0013\u0017\u0003\u0003GAsaBA\"\u0003\u0017\n9*\t\u0002\u0002\u001a\u0006i#+Z:v[\u0016\u0004C.Z1eKJ\u0004S\r\\3di&|g\u000eI1uAQDW\rI2veJ,g\u000e\u001e\u0011tKJ4XM\u001d\u0018\u0002\u000fA,WM]!eIR\u0019A+a(\t\ryC\u0001\u0019AAQ!\r)\u00161U\u0005\u0004\u0003K3&a\u0005*bi&\u001c\b+Z3s\u0003\u0012$'+Z9vKN$\b&\u0002\u0005d[\u0006%F&A8)\u000b!\u0011X.!,\"\u0005\u0005=\u0016!C\u0018qK\u0016\u0014x&\u00193eQ\tA\u0001\u0010\u000b\u0006\ty\u0006e\u00111DA\u0010\u0003kc#!a\t)\u000f!\t\u0019%a\u0013\u0002:\u0006\u0012\u00111X\u0001!\u0003\u0012$\u0007E\\3xAA,WM]:!i>\u0004C\u000f[3!e\u00064G\u000fI4s_V\u0004h&\u0001\u0006qK\u0016\u0014(+Z7pm\u0016$2\u0001VAa\u0011\u0019q\u0016\u00021\u0001\u0002DB\u0019Q+!2\n\u0007\u0005\u001dgK\u0001\fSCRL7\u000fU3feJ+Wn\u001c<f%\u0016\fX/Z:uQ\u0015I1-\\AfY\u0005y\u0007&B\u0005s[\u0006=\u0017EAAi\u00031y\u0003/Z3s_I,Wn\u001c<fQ\tI\u0001\u0010\u000b\u0006\ny\u0006e\u00111DA\u0010\u0003/d#!a\t)\u000f%\t\u0019%a\u0013\u0002\\\u0006\u0012\u0011Q\\\u0001\"%\u0016lwN^3!a\u0016,'o\u001d\u0011ge>l\u0007\u0005\u001e5fAI\fg\r\u001e\u0011he>,\bOL\u0001\u0010a\u0016,'oU3u!JLwN]5usR\u0019A+a9\t\ryS\u0001\u0019AAs!\r)\u0016q]\u0005\u0004\u0003S4&a\u0007*bi&\u001c\b+Z3s'\u0016$\bK]5pe&$\u0018PU3rk\u0016\u001cH\u000fK\u0003\u000bG6\fi\u000fL\u0001pQ\u0015Q!/\\AyC\t\t\u00190\u0001\n0a\u0016,'oL:fi~\u0003(/[8sSRL\bF\u0001\u0006yQ)QA0!\u0007\u0002\u001c\u0005}\u0011\u0011 \u0017\u0003\u0003GAsACA\"\u0003\u0017\ni0\t\u0002\u0002\u0000\u0006\u00014+\u001a;!i\",\u0007\u0005\u001d:j_JLG/\u001f\u0011pM\u0002\"\b.\u001a\u0011qK\u0016\u00148\u000fI5oAQDW\r\t:bMR\u0004sM]8va:\nab\u0019:fCR,7K\\1qg\"|G\u000fK\u0003\fG6\u0014)\u0001L\u0001pQ\u0015Y!/\u001cB\u0005C\t\u0011Y!\u0001\t0g:\f\u0007o\u001d5pi>\u001a'/Z1uK\"\u00121\u0002\u001f\u0015\u000b\u0017q\fI\"a\u0007\u0002 \tEAFAA\u0012Q\u001dY\u00111IA&\u0005+\t#Aa\u0006\u0002YQ\u0013\u0018nZ4fe\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!g\u0016\u0014h/\u001a:!i>\u0004C/Y6fAMt\u0017\r]:i_Rt\u0013\u0001F4fi2{7-\u00197SC\u001a$X*\u001a;b\u0007>tg\r\u0006\u0002\u0003\u001eA!!q\u0004B\u0013\u001b\t\u0011\tCC\u0002\u0003$\u0015\fAaY8sK&!!q\u0005B\u0011\u0005!\u0011Vm\u001d9p]N,\u0007&\u0002\u0007d[\n-BF\u0001B\u0017C\t\u0011y#\u0001\rbaBd\u0017nY1uS>twf\\2uKRl3\u000f\u001e:fC6DS\u0001\u0004:n\u0005g\t#A!\u000e\u0002+=bwnY1m_I\fg\r^0nKR\fwlY8oM\"\u001aAB!\u000f\u0011\u0007\u0011\u0014Y$C\u0002\u0003>\u0015\u00141aR#UQ)aA0!\u0007\u0002\u001c\u0005}!\u0011\t\u0017\u0003\u0005\u0007Z#\"!\n\u00022\t5\u00121\u0007B#W\u0019\t9$!\u0010\u0003H\r\u0012!Q\u0004\u0015\b\u0019\u0005\r\u00131\nB&C\t\u0011i%\u0001\u001aHKR\u0004C\u000f[3!e\u00064G/L7fi\u0006t3m\u001c8gA\u0019LG.\u001a\u0011pM\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!g\u0016\u0014h/\u001a:/\u0003]9WM\\3sCR,g*Z<SC\u001a$X*\u001a;b\u0007>tg\r\u0006\u0003\u0003\u001e\tM\u0003B\u00020\u000e\u0001\u0004\u0011)\u0006E\u0002V\u0005/J1A!\u0017W\u0005u\u0011\u0016\r^5t\u0019>\u001c\u0017\r\u001c*bMRlU\r^1D_:4'+Z9vKN$\b&B\u0007d[\nuCF\u0001B\u0017Q\u0015i!/\u001cB\u001aQ\ti\u0001\u0010\u000b\u0006\u000ey\u0006e\u00111DA\u0010\u0005Kb#Aa\u0011)\u000f5\t\u0019%a\u0013\u0003j\u0005\u0012!1N\u0001\u0002\b\u001d+g.\u001a:bi\u0016\u0004\u0013\r\t8fo6\u0012\u0018M\u001a;.[\u0016$\u0018ML2p]\u001a\u0004c-\u001b7fA\t\f7/\u001a3!_:\u0004sN]5hS:\fG\u000e\t:bMRlS.\u001a;b]\r|gN\u001a\u0011b]\u0012\u0004c.Z<!a\u0016,'o\u001d\u0017!o\"L7\r\u001b\u0011jg\u0002*8/\u001a3!i>\u0004Sn\u001c<fA\u0005\u0004#/\u00194uA9|G-\u001a\u0011u_\u0002\n\u0007E\\3xA9|G-\u001a\u0018\u0002%Q\u0014\u0018M\\:gKJdU-\u00193feND\u0017\u000e\u001d\u000b\u0004)\nE\u0004b\u0002B:\u001d\u0001\u0007!QO\u0001\fa\u0016,'/\u00113ee\u0016\u001c8\u000f\u0005\u0003\u0003x\t\u0015e\u0002\u0002B=\u0005\u0003\u00032Aa\u001f+\u001b\t\u0011iHC\u0002\u0003\u0000\u0019\na\u0001\u0010:p_Rt\u0014b\u0001BBU\u00051\u0001K]3eK\u001aLAAa\"\u0003\n\n11\u000b\u001e:j]\u001eT1Aa!+\u0003=\t\u0007\u000f\u001d7z\u000b2,7\r^5p]>\u0003Hc\u0001+\u0003\u0010\"9!\u0011S\bA\u0002\tM\u0015AA8q!\u0011\u0011)J!*\u000f\t\t]%\u0011U\u0007\u0003\u00053SAAa'\u0003\u001e\u0006A\u0001O]8u_\u000e|GNC\u0002\u0003 \n\nQA]1uSNLAAa)\u0003\u001a\u0006yB*Z1eKJ,E.Z2uS>tW*\u00198bO\u0016lWM\u001c;SKF,Xm\u001d;\n\t\t\u001d&\u0011\u0016\u0002\u0003\u001fBTAAa)\u0003\u001a\u0006\u00012/\u001a;D_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0005_\u0013)\f\u0005\u0003\u0003\u0018\nE\u0016\u0002\u0002BZ\u00053\u0013qBU1gi\u000ec\u0017.\u001a8u%\u0016\u0004H.\u001f\u0005\b\u0005o\u0003\u0002\u0019\u0001B]\u0003\u0015\u0001X-\u001a:t!\u0019\u0011YL!2\u0003L:!!Q\u0018Ba\u001d\u0011\u0011YHa0\n\u0003-J1Aa1+\u0003\u001d\u0001\u0018mY6bO\u0016LAAa2\u0003J\n\u00191+Z9\u000b\u0007\t\r'\u0006\u0005\u0003\u0003\u0018\n5\u0017\u0002\u0002Bh\u00053\u0013\u0001BU1giB+WM]\u0001\rO\u0016$(+\u00194u!\u0016,'o\u001d\u000b\u0003\u0005s\u000bA&\u001a8tkJ,G*Z1eKJ,E.Z2uS>tW*Z7cKJl\u0015M[8sSRL\u0018\t\u001a3F]\u0006\u0014G.\u001a3\u0016\t\te'\u0011\u001d\u000b\u0005\u00057\u0014i\u0010\u0006\u0003\u0003^\nM\b\u0003\u0002Bp\u0005Cd\u0001\u0001B\u0004\u0003dJ\u0011\rA!:\u0003\u0003Q\u000bBAa:\u0003nB\u0019\u0011F!;\n\u0007\t-(FA\u0004O_RD\u0017N\\4\u0011\u0007%\u0012y/C\u0002\u0003r*\u00121!\u00118z\u0011!\u0011)P\u0005CA\u0002\t]\u0018!\u00014\u0011\u000b%\u0012IP!8\n\u0007\tm(F\u0001\u0005=Eft\u0017-\\3?\u0011\u0015Y\"\u00031\u0001EQ\u0019\u00011\u0011A7\u0004\bA\u0019Ama\u0001\n\u0007\r\u0015QM\u0001\u0005D_:\u001cX/\\3tY\u0005y\u0007f\u0002\u0001\u0004\f\r]1\u0011\u0004\t\u0005\u0007\u001b\u0019\u0019\"\u0004\u0002\u0004\u0010)!1\u0011CA\u0001\u0003\u0011!\u0018mZ:\n\t\rU1q\u0002\u0002\u0004)\u0006<\u0017\u0001\u00028b[\u0016\f#aa\u0007\u0002\u000bI\u000bG/[:")
public class RatisResource
implements ApiRequestContext,
Logging {
    private transient Logger log;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public final HttpService httpService() {
        return ApiRequestContext.httpService$((ApiRequestContext)this);
    }

    public String normalizeParam(String param) {
        return ApiRequestContext.normalizeParam$((ApiRequestContext)this, (String)param);
    }

    private Logger log$lzycompute() {
        RatisResource ratisResource = this;
        synchronized (ratisResource) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public ServletContext servletContext() {
        return this.servletContext;
    }

    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private Master master() {
        return (Master)this.httpService();
    }

    private HARaftServer ratisServer() {
        return ((HAMasterMetaManager)this.master().statusSystem()).getRatisServer();
    }

    @Operation(description="Transfer the group leader to the specified server.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/election/transfer")
    @Produces(value={"application/json"})
    public HandleResponse electionTransfer(RatisElectionTransferRequest request) {
        return (HandleResponse)MasterHttpResourceUtils$.MODULE$.ensureMasterIsLeader(this.master(), (Function0 & Serializable & scala.Serializable)() -> this.transferLeadership(request.getPeerAddress()));
    }

    @Operation(description="Make the group leader step down its leadership.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/election/step_down")
    @Produces(value={"application/json"})
    public HandleResponse electionStepDown() {
        return (HandleResponse)MasterHttpResourceUtils$.MODULE$.ensureMasterIsLeader(this.master(), (Function0 & Serializable & scala.Serializable)() -> this.transferLeadership(null));
    }

    @Operation(description="Pause leader election at the current server. Then, the current server would not start a leader election.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/election/pause")
    @Produces(value={"application/json"})
    public HandleResponse electionPause() {
        return (HandleResponse)MasterHttpResourceUtils$.MODULE$.ensureMasterHAEnabled(this.master(), (Function0 & Serializable & scala.Serializable)() -> this.applyElectionOp((LeaderElectionManagementRequest.Op)new LeaderElectionManagementRequest.Pause()));
    }

    @Operation(description="Resume leader election at the current server.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/election/resume")
    @Produces(value={"application/json"})
    public HandleResponse electionResume() {
        return (HandleResponse)MasterHttpResourceUtils$.MODULE$.ensureMasterHAEnabled(this.master(), (Function0 & Serializable & scala.Serializable)() -> this.applyElectionOp((LeaderElectionManagementRequest.Op)new LeaderElectionManagementRequest.Resume()));
    }

    @Operation(description="Add new peers to the raft group.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/peer/add")
    @Produces(value={"application/json"})
    public HandleResponse peerAdd(RatisPeerAddRequest request) {
        return (HandleResponse)this.ensureLeaderElectionMemberMajorityAddEnabled(this.master(), (Function0 & Serializable & scala.Serializable)() -> {
            if (request.getPeers().isEmpty()) {
                throw new BadRequestException("No peers specified.");
            }
            GroupInfoReply groupInfo = this.ratisServer().getGroupInfo();
            Seq<RaftPeer> remaining = this.getRaftPeers();
            Buffer adding = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.getPeers()).asScala()).map((Function1 & Serializable & scala.Serializable)peer -> {
                if (remaining.exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)RatisResource.$anonfun$peerAdd$3(peer, e)))) {
                    throw new IllegalArgumentException(new StringBuilder(55).append("Peer ").append(peer).append(" with same id or address already exists in group ").append(groupInfo).append(".").toString());
                }
                return RaftPeer.newBuilder().setId(peer.getId()).setAddress(peer.getAddress()).setPriority(0).build();
            }, Buffer$.MODULE$.canBuildFrom());
            Seq peers = (Seq)((SeqLike)remaining.$plus$plus((GenTraversableOnce)adding, Seq$.MODULE$.canBuildFrom())).distinct();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Adding peers: ").append(adding).append(" to group ").append(groupInfo).append(".").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("New peers: ").append(peers).toString());
            RaftClientReply reply = this.setConfiguration((Seq<RaftPeer>)peers);
            if (reply.isSuccess()) {
                return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(36).append("Successfully added peers ").append(adding).append(" to group ").append(groupInfo).append(".").toString());
            }
            return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(false)).message(new StringBuilder(32).append("Failed to add peers ").append(adding).append(" to group ").append(groupInfo).append(". ").append(reply).toString());
        });
    }

    @Operation(description="Remove peers from the raft group.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/peer/remove")
    @Produces(value={"application/json"})
    public HandleResponse peerRemove(RatisPeerRemoveRequest request) {
        return (HandleResponse)this.ensureLeaderElectionMemberMajorityAddEnabled(this.master(), (Function0 & Serializable & scala.Serializable)() -> {
            if (request.getPeers().isEmpty()) {
                throw new BadRequestException("No peers specified.");
            }
            GroupInfoReply groupInfo = this.ratisServer().getGroupInfo();
            Buffer removing = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.getPeers()).asScala()).map((Function1 & Serializable & scala.Serializable)peer -> (RaftPeer)this.getRaftPeers().find((Function1 & Serializable & scala.Serializable)raftPeer -> BoxesRunTime.boxToBoolean((boolean)RatisResource.$anonfun$peerRemove$3(peer, raftPeer))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(26).append("Peer ").append(peer).append(" not found in group ").append(groupInfo).append(".").toString());
            }), Buffer$.MODULE$.canBuildFrom());
            Seq remaining = (Seq)this.getRaftPeers().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)removing.contains(elem)));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Removing peers:").append(removing).append(" from group ").append(groupInfo).append(".").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("New peers: ").append(remaining).toString());
            RaftClientReply reply = this.setConfiguration((Seq<RaftPeer>)remaining);
            if (reply.isSuccess()) {
                return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(40).append("Successfully removed peers ").append(removing).append(" from group ").append(groupInfo).append(".").toString());
            }
            return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(false)).message(new StringBuilder(37).append("Failed to remove peers ").append(removing).append(" from group ").append(groupInfo).append(". ").append(reply).toString());
        });
    }

    @Operation(description="Set the priority of the peers in the raft group.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/peer/set_priority")
    @Produces(value={"application/json"})
    public HandleResponse peerSetPriority(RatisPeerSetPriorityRequest request) {
        return (HandleResponse)this.ensureLeaderElectionMemberMajorityAddEnabled(this.master(), (Function0 & Serializable & scala.Serializable)() -> {
            if (request.getAddressPriorities().isEmpty()) {
                throw new BadRequestException("No peer priorities specified.");
            }
            Seq peers = (Seq)this.getRaftPeers().map((Function1 & Serializable & scala.Serializable)peer -> {
                Integer newPriority = (Integer)request.getAddressPriorities().get(peer.getAddress());
                int priority = newPriority != null ? Predef$.MODULE$.Integer2int(newPriority) : peer.getPriority();
                return RaftPeer.newBuilder((RaftPeer)peer).setPriority(priority).build();
            }, Seq$.MODULE$.canBuildFrom());
            String peerPriorities = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getAddressPriorities()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String a = (String)tuple2._1();
                    Integer p = (Integer)tuple2._2();
                    return new StringBuilder(1).append(a).append(":").append(p).toString();
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Setting peer priorities: ").append(peerPriorities).append(".").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("New peers: ").append(peers).toString());
            RaftClientReply reply = this.setConfiguration((Seq<RaftPeer>)peers);
            if (reply.isSuccess()) {
                return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(35).append("Successfully set peer priorities: ").append(peerPriorities).append(".").toString());
            }
            return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(false)).message(new StringBuilder(33).append("Failed to set peer priorities: ").append(peerPriorities).append(". ").append(reply).toString());
        });
    }

    @Operation(description="Trigger the current server to take snapshot.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/snapshot/create")
    @Produces(value={"application/json"})
    public HandleResponse createSnapshot() {
        return (HandleResponse)MasterHttpResourceUtils$.MODULE$.ensureMasterHAEnabled(this.master(), (Function0 & Serializable & scala.Serializable)() -> {
            SnapshotManagementRequest request = SnapshotManagementRequest.newCreate((ClientId)this.ratisServer().getClientId(), (RaftPeerId)this.ratisServer().getServer().getId(), (RaftGroupId)this.ratisServer().getGroupId(), (long)CallId.getAndIncrement(), (long)HARaftServer.REQUEST_TIMEOUT_MS);
            RaftClientReply reply = this.ratisServer().getServer().snapshotManagement(request);
            if (reply.isSuccess()) {
                return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(64).append("Successfully create snapshot at ").append(this.ratisServer().getLocalAddress()).append(". The latest snapshot index is ").append(reply.getLogIndex()).append(".").toString());
            }
            return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(false)).message(new StringBuilder(31).append("Failed to create snapshot at ").append(this.ratisServer().getLocalAddress()).append(". ").append(reply).toString());
        });
    }

    @Operation(description="Get the raft-meta.conf file of the current server.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/octet-stream", schema=@Schema(implementation=Response.class))})
    @GET
    @Path(value="/local/raft_meta_conf")
    @Produces(value={"application/octet-stream"})
    public Response getLocalRaftMetaConf() {
        return (Response)MasterHttpResourceUtils$.MODULE$.ensureMasterHAEnabled(this.master(), (Function0 & Serializable & scala.Serializable)() -> {
            java.nio.file.Path raftMetaConfFile = Paths.get(this.master().conf().haMasterRatisStorageDir(), this.ratisServer().getGroupId().getUuid().toString(), "current", "raft-meta.conf");
            if (!raftMetaConfFile.toFile().exists()) {
                throw new NotFoundException(new StringBuilder(16).append("File ").append(raftMetaConfFile).append(" not found.").toString());
            }
            return Response.ok((Object)IOUtils.toByteArray((URI)raftMetaConfFile.toUri())).header("Content-Disposition", (Object)"attachment; filename=\"raft-meta.conf\"").build();
        });
    }

    @Operation(description="Generate a new-raft-meta.conf file based on original raft-meta.conf and new peers, which is used to move a raft node to a new node.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/octet-stream", schema=@Schema(implementation=Response.class))})
    @POST
    @Path(value="/local/raft_meta_conf")
    @Produces(value={"application/octet-stream"})
    public Response generateNewRaftMetaConf(RatisLocalRaftMetaConfRequest request) {
        return (Response)MasterHttpResourceUtils$.MODULE$.ensureMasterHAEnabled(this.master(), (Function0 & Serializable & scala.Serializable)() -> {
            if (request.getPeers().isEmpty()) {
                throw new BadRequestException("No peers specified.");
            }
            GroupInfoReply groupInfo = this.ratisServer().getGroupInfo();
            Seq existingPeers = (Seq)this.getRaftPeers().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getRaftPeerProto(), Seq$.MODULE$.canBuildFrom());
            Buffer newPeers = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.getPeers()).asScala()).map((Function1 & Serializable & scala.Serializable)peer -> RaftProtos.RaftPeerProto.newBuilder().setId(ByteString.copyFrom((byte[])peer.getId().getBytes(StandardCharsets.UTF_8))).setAddress(peer.getAddress()).setStartupRole(RaftProtos.RaftPeerRole.FOLLOWER).build(), Buffer$.MODULE$.canBuildFrom());
            Seq remainingPeers = (Seq)existingPeers.filterNot((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)newPeers.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RatisResource.$anonfun$generateNewRaftMetaConf$5(p, x$2)))));
            Seq allPeers = (Seq)remainingPeers.$plus$plus((GenTraversableOnce)newPeers, Seq$.MODULE$.canBuildFrom());
            long newIndex = groupInfo.getLogIndex() + 1L;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Generating new-raft-meta.conf with remaining peers:").append(" ").append(remainingPeers).append(" and new peers: ").append(newPeers).append(", index: ").append(newIndex).append(".").toString());
            RaftProtos.LogEntryProto generateLogEntryProto = RaftProtos.LogEntryProto.newBuilder().setConfigurationEntry(RaftProtos.RaftConfigurationProto.newBuilder().addAllPeers((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(allPeers).asJava()).build()).setIndex(newIndex).build();
            return Response.ok((Object)generateLogEntryProto.toByteArray()).header("Content-Disposition", (Object)"attachment; filename=\"new-raft-meta.conf\"").build();
        });
    }

    private HandleResponse transferLeadership(String peerAddress) {
        RaftPeerId newLeaderId = (RaftPeerId)Option$.MODULE$.apply((Object)peerAddress).map((Function1 & Serializable & scala.Serializable)addr -> (RaftPeerId)this.getRaftPeers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RatisResource.$anonfun$transferLeadership$2(addr, x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(26).append("Peer ").append((String)addr).append(" not found in group ").append(this.ratisServer().getGroupInfo()).append(".").toString());
        })).orNull(Predef$.MODULE$.$conforms());
        String op = newLeaderId == null ? new StringBuilder(17).append("step down leader ").append(this.ratisServer().getLocalAddress()).toString() : new StringBuilder(29).append("transfer leadership from ").append(this.ratisServer().getLocalAddress()).append(" to ").append(peerAddress).toString();
        TransferLeadershipRequest request = new TransferLeadershipRequest(this.ratisServer().getClientId(), this.ratisServer().getServer().getId(), this.ratisServer().getGroupId(), CallId.getAndIncrement(), newLeaderId, HARaftServer.REQUEST_TIMEOUT_MS);
        RaftClientReply reply = this.ratisServer().getServer().transferLeadership(request);
        if (reply.isSuccess()) {
            return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(14).append("Successfully ").append(op).append(".").toString());
        }
        return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(false)).message(new StringBuilder(12).append("Failed to ").append(op).append(": ").append(reply).toString());
    }

    private HandleResponse applyElectionOp(LeaderElectionManagementRequest.Op op) {
        LeaderElectionManagementRequest request = new LeaderElectionManagementRequest(this.ratisServer().getClientId(), this.ratisServer().getServer().getId(), this.ratisServer().getGroupId(), CallId.getAndIncrement(), op);
        RaftClientReply reply = this.ratisServer().getServer().leaderElectionManagement(request);
        if (reply.isSuccess()) {
            return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(32).append("Successfully applied election ").append(op).append(" ").append(this.ratisServer().getLocalAddress()).append(".").toString());
        }
        return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(false)).message(new StringBuilder(28).append("Failed to apply election ").append(op).append(" ").append(this.ratisServer().getLocalAddress()).append(". ").append(reply).toString());
    }

    private RaftClientReply setConfiguration(Seq<RaftPeer> peers) {
        return this.ratisServer().getServer().setConfiguration(new SetConfigurationRequest(this.ratisServer().getClientId(), this.ratisServer().getServer().getId(), this.ratisServer().getGroupId(), CallId.getAndIncrement(), SetConfigurationRequest.Arguments.newBuilder().setServersInNewConf((List)JavaConverters$.MODULE$.seqAsJavaListConverter(peers).asJava()).build()));
    }

    private Seq<RaftPeer> getRaftPeers() {
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.ratisServer().getGroupInfo().getGroup().getPeers()).asScala()).toSeq();
    }

    private <T> T ensureLeaderElectionMemberMajorityAddEnabled(Master master, Function0<T> f) {
        return MasterHttpResourceUtils$.MODULE$.ensureMasterIsLeader(master, (Function0 & Serializable & scala.Serializable)() -> {
            if (!master.conf().hasMasterRatisLeaderElectionMemberMajorityAdd()) {
                throw new BadRequestException(new StringBuilder(46).append("This operation can only be done when").append(" ").append(CelebornConf$.MODULE$.HA_MASTER_RATIS_LEADER_ELECTION_MEMBER_MAJORITY_ADD().key()).append(" is true.").toString());
            }
            return f.apply();
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$peerAdd$3(RatisPeer peer$1, RaftPeer e) {
        String string = e.getId().toString();
        String string2 = peer$1.getId();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = e.getAddress();
        String string4 = peer$1.getAddress();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$peerRemove$3(RatisPeer peer$2, RaftPeer raftPeer) {
        String string = raftPeer.getId().toString();
        String string2 = peer$2.getId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = raftPeer.getAddress();
        String string4 = peer$2.getAddress();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$generateNewRaftMetaConf$5(RaftProtos.RaftPeerProto p$1, RaftProtos.RaftPeerProto x$2) {
        String string = x$2.getId().toStringUtf8();
        String string2 = p$1.getId().toStringUtf8();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$transferLeadership$2(String addr$1, RaftPeer x$3) {
        String string = x$3.getAddress();
        String string2 = addr$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public RatisResource() {
        ApiRequestContext.$init$((ApiRequestContext)this);
        Logging.$init$((Logging)this);
    }
}

