/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.io.Serializable;
import java.util.Objects;
import org.apache.celeborn.common.protocol.WorkerEventType;

public class WorkerEventInfo
implements Serializable {
    private static final long serialVersionUID = 5681914909039445235L;
    private int eventTypeValue;
    private long eventStartTime;

    public WorkerEventInfo(int eventTypeValue, long eventStartTime) {
        this.eventTypeValue = eventTypeValue;
        this.eventStartTime = eventStartTime;
    }

    public boolean isSameEvent(int eventTypeValue) {
        return this.eventTypeValue == eventTypeValue;
    }

    public WorkerEventType getEventType() {
        return WorkerEventType.forNumber(this.eventTypeValue);
    }

    public long getEventStartTime() {
        return this.eventStartTime;
    }

    public void setEventStartTime(long eventStartTime) {
        this.eventStartTime = eventStartTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkerEventInfo)) {
            return false;
        }
        WorkerEventInfo that = (WorkerEventInfo)o;
        return this.eventTypeValue == that.eventTypeValue && this.getEventStartTime() == that.getEventStartTime();
    }

    public int hashCode() {
        return Objects.hash(this.eventTypeValue, this.getEventStartTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorkerEventInfo{");
        sb.append("eventType=").append(this.getEventType());
        sb.append(", eventStartTime=").append(this.eventStartTime);
        sb.append('}');
        return sb.toString();
    }
}

