/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.celeborn.common.CelebornConf;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.runtime.metrics.groups.ShuffleMetricGroup;
import org.apache.flink.runtime.shuffle.ShuffleIOOwnerContext;

public class ShuffleIOMetricGroup
extends ProxyMetricGroup<MetricGroup> {
    private final Counter numBytesIn = this.counter("numBytesIn", (Counter)new SimpleCounter());
    private final Counter numBytesOut = this.counter("numBytesOut", (Counter)new SimpleCounter());
    private final Counter numRecordsOut = this.counter("numRecordsOut", (Counter)new SimpleCounter());
    private final Meter numBytesInRate = this.meter("numBytesInPerSecond", (Meter)new MeterView(this.numBytesIn));
    private final Meter numBytesOutRate = this.meter("numBytesOutPerSecond", (Meter)new MeterView(this.numBytesOut));
    private final Meter numRecordsOutRate = this.meter("numRecordsOutPerSecond", (Meter)new MeterView(this.numRecordsOut));

    public ShuffleIOMetricGroup(ShuffleMetricGroup parent) {
        super((MetricGroup)parent);
    }

    public Counter getNumBytesIn() {
        return this.numBytesIn;
    }

    public Counter getNumBytesOut() {
        return this.numBytesOut;
    }

    public Counter getNumRecordsOut() {
        return this.numRecordsOut;
    }

    public Meter getNumBytesInRate() {
        return this.numBytesInRate;
    }

    public Meter getNumBytesOutRate() {
        return this.numBytesOutRate;
    }

    public Meter getNumRecordsOutRate() {
        return this.numRecordsOutRate;
    }

    public static ShuffleIOMetricGroup createShuffleIOMetricGroup(ShuffleIOOwnerContext ownerContext, int shuffleId, CelebornConf celebornConf) {
        return new ShuffleMetricGroup(ownerContext.getParentGroup(), shuffleId, celebornConf.clientFlinkMetricsScopeNamingShuffle()).getIOMetricGroup();
    }
}

