/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.ibatis.ognl.NoSuchPropertyException;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlOps;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.PropertyAccessor;
import org.apache.ibatis.ognl.enhance.ExpressionCompiler;
import org.apache.ibatis.ognl.enhance.UnsupportedCompilationException;

public class ObjectPropertyAccessor
implements PropertyAccessor {
    public Object getPossibleProperty(OgnlContext context, Object target, String name) throws OgnlException {
        Object result;
        try {
            result = OgnlRuntime.getMethodValue(context, target, name, true);
            if (result == OgnlRuntime.NotFound) {
                result = OgnlRuntime.getFieldValue(context, target, name, true);
            }
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException(name, ex);
        }
        return result;
    }

    public Object setPossibleProperty(OgnlContext context, Object target, String name, Object value) throws OgnlException {
        Object result = null;
        try {
            Method m;
            if (!OgnlRuntime.setMethodValue(context, target, name, value, true)) {
                Object object = result = OgnlRuntime.setFieldValue(context, target, name, value) ? null : OgnlRuntime.NotFound;
            }
            if (result == OgnlRuntime.NotFound && (m = OgnlRuntime.getWriteMethod(target.getClass(), name)) != null) {
                result = m.invoke(target, value);
            }
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException(name, ex);
        }
        return result;
    }

    public boolean hasGetProperty(OgnlContext context, Object target, Object oname) throws OgnlException {
        try {
            return OgnlRuntime.hasGetProperty(context, target, oname);
        }
        catch (IntrospectionException ex) {
            throw new OgnlException("checking if " + target + " has gettable property " + oname, ex);
        }
    }

    public boolean hasSetProperty(OgnlContext context, Object target, Object oname) throws OgnlException {
        try {
            return OgnlRuntime.hasSetProperty(context, target, oname);
        }
        catch (IntrospectionException ex) {
            throw new OgnlException("checking if " + target + " has settable property " + oname, ex);
        }
    }

    @Override
    public Object getProperty(OgnlContext context, Object target, Object oname) throws OgnlException {
        String name = oname.toString();
        Object result = this.getPossibleProperty(context, target, name);
        if (result == OgnlRuntime.NotFound) {
            throw new NoSuchPropertyException(target, name);
        }
        return result;
    }

    @Override
    public void setProperty(OgnlContext context, Object target, Object oname, Object value) throws OgnlException {
        String name = oname.toString();
        Object result = this.setPossibleProperty(context, target, name, value);
        if (result == OgnlRuntime.NotFound) {
            throw new NoSuchPropertyException(target, name);
        }
    }

    public Class<?> getPropertyClass(OgnlContext context, Object target, Object index) {
        try {
            Method m = OgnlRuntime.getReadMethod(target.getClass(), index.toString());
            if (m == null) {
                if (String.class.isAssignableFrom(index.getClass()) && !target.getClass().isArray()) {
                    String indexStr = (String)index;
                    String key = indexStr.indexOf(34) >= 0 ? indexStr.replaceAll("\"", "") : indexStr;
                    try {
                        Field f = target.getClass().getField(key);
                        return f.getType();
                    }
                    catch (NoSuchFieldException e) {
                        return null;
                    }
                }
                return null;
            }
            return m.getReturnType();
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
    }

    @Override
    public String getSourceAccessor(OgnlContext context, Object target, Object index) {
        try {
            String indexStr = index.toString();
            String methodName = indexStr.indexOf(34) >= 0 ? indexStr.replaceAll("\"", "") : indexStr;
            Method m = OgnlRuntime.getReadMethod(target.getClass(), methodName);
            if (m == null && context.getCurrentObject() != null) {
                String currentObjectStr = context.getCurrentObject().toString();
                m = OgnlRuntime.getReadMethod(target.getClass(), currentObjectStr.indexOf(34) >= 0 ? currentObjectStr.replaceAll("\"", "") : currentObjectStr);
            }
            if (m == null) {
                try {
                    if (String.class.isAssignableFrom(index.getClass()) && !target.getClass().isArray()) {
                        Field f = target.getClass().getField(methodName);
                        context.setCurrentType(f.getType());
                        context.setCurrentAccessor(f.getDeclaringClass());
                        return "." + f.getName();
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                return "";
            }
            context.setCurrentType(m.getReturnType());
            context.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
            return "." + m.getName() + "()";
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
    }

    @Override
    public String getSourceSetter(OgnlContext context, Object target, Object index) {
        try {
            String conversion;
            String indexStr = index.toString();
            String methodName = indexStr.indexOf(34) >= 0 ? indexStr.replaceAll("\"", "") : indexStr;
            Method m = OgnlRuntime.getWriteMethod(target.getClass(), methodName);
            if (m == null && context.getCurrentObject() != null && context.getCurrentObject().toString() != null) {
                String currentObjectStr = context.getCurrentObject().toString();
                m = OgnlRuntime.getWriteMethod(target.getClass(), currentObjectStr.indexOf(34) >= 0 ? currentObjectStr.replaceAll("\"", "") : currentObjectStr);
            }
            if (m == null || m.getParameterTypes().length <= 0) {
                throw new UnsupportedCompilationException("Unable to determine setting expression on " + context.getCurrentObject() + " with index of " + index);
            }
            Class<?> param = m.getParameterTypes()[0];
            if (m.getParameterTypes().length > 1) {
                throw new UnsupportedCompilationException("Object property accessors can only support single parameter setters.");
            }
            if (param.isPrimitive()) {
                Class<?> wrapClass = OgnlRuntime.getPrimitiveWrapperClass(param);
                conversion = OgnlRuntime.getCompiler().createLocalReference(context, "((" + wrapClass.getName() + ")ognl.OgnlOps#convertValue($3," + wrapClass.getName() + ".class, true))." + OgnlRuntime.getNumericValueGetter(wrapClass), param);
            } else {
                conversion = param.isArray() ? OgnlRuntime.getCompiler().createLocalReference(context, "(" + ExpressionCompiler.getCastString(param) + ")ognl.OgnlOps#toArray($3," + param.getComponentType().getName() + ".class)", param) : OgnlRuntime.getCompiler().createLocalReference(context, "(" + param.getName() + ")ognl.OgnlOps#convertValue($3," + param.getName() + ".class)", param);
            }
            context.setCurrentType(m.getReturnType());
            context.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
            return "." + m.getName() + "(" + conversion + ")";
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
    }
}

