/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.example;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.cli.help.FilterHelpAppendable;
import org.apache.commons.cli.help.TableDefinition;
import org.apache.commons.cli.help.TextStyle;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.LookupTranslator;

public class AptHelpAppendable
extends FilterHelpAppendable {
    public static final CharSequenceTranslator ESCAPE_APT;

    public AptHelpAppendable(Appendable output) {
        super(output);
    }

    public void appendHeader(int level, CharSequence text) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            if (level < 1) {
                throw new IllegalArgumentException("level must be at least 1");
            }
            for (int i = 0; i < level; ++i) {
                this.output.append("*");
            }
            this.appendFormat(" %s%n%n", new Object[]{ESCAPE_APT.translate(text)});
        }
    }

    public void appendList(boolean ordered, Collection<CharSequence> list) throws IOException {
        if (list != null) {
            if (ordered) {
                int idx = 1;
                for (CharSequence s : list) {
                    this.appendFormat("    [[%s]] %s%n", new Object[]{idx++, ESCAPE_APT.translate(s)});
                }
            } else {
                for (CharSequence s : list) {
                    this.appendFormat("    * %s%n", new Object[]{ESCAPE_APT.translate(s)});
                }
            }
            this.output.append(System.lineSeparator());
        }
    }

    public void appendParagraph(CharSequence paragraph) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)paragraph)) {
            this.appendFormat("  %s%n%n", new Object[]{ESCAPE_APT.translate(paragraph)});
        }
    }

    public void appendTable(TableDefinition table) throws IOException {
        if (table != null) {
            StringBuilder sb = new StringBuilder("*");
            block5: for (int i = 0; i < table.headers().size(); ++i) {
                String header = (String)table.headers().get(i);
                TextStyle style = (TextStyle)table.columnTextStyles().get(i);
                sb.append(StringUtils.repeat((char)'-', (int)(header.length() + 2)));
                switch (style.getAlignment()) {
                    case LEFT: {
                        sb.append("+");
                        continue block5;
                    }
                    case CENTER: {
                        sb.append("*");
                        continue block5;
                    }
                    case RIGHT: {
                        sb.append(":");
                    }
                }
            }
            String rowSeparator = System.lineSeparator() + sb.append(System.lineSeparator());
            this.output.append(sb.toString());
            this.output.append("|");
            for (String header : table.headers()) {
                this.appendFormat(" %s |", new Object[]{ESCAPE_APT.translate((CharSequence)header)});
            }
            this.output.append(rowSeparator);
            for (Collection row : table.rows()) {
                this.output.append("|");
                for (String cell : row) {
                    this.appendFormat(" %s |", new Object[]{ESCAPE_APT.translate((CharSequence)cell)});
                }
                this.output.append(rowSeparator);
            }
            if (StringUtils.isNotEmpty((CharSequence)table.caption())) {
                this.appendFormat("%s%n", new Object[]{ESCAPE_APT.translate((CharSequence)table.caption())});
            }
            this.output.append(System.lineSeparator());
        }
    }

    public void appendTitle(CharSequence title) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)title)) {
            this.appendFormat("        -----%n        %1$s%n        -----%n%n%1$s%n%n", new Object[]{title});
        }
    }

    static {
        HashMap<String, String> escapeAptMap = new HashMap<String, String>();
        escapeAptMap.put("\\", "\\\\");
        escapeAptMap.put("\"", "\\\"");
        escapeAptMap.put("*", "\\*");
        escapeAptMap.put("+", "\\+");
        escapeAptMap.put("|", "\\|");
        ESCAPE_APT = new LookupTranslator(escapeAptMap);
    }
}

