/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.commons.dbcp2.AbandonedTrace;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterResultSet;

public class TesterStatement
extends AbandonedTrace
implements Statement {
    protected final Connection connection;
    protected boolean open = true;
    protected final long rowsUpdated = 1L;
    protected final boolean executeResponse = true;
    protected int maxFieldSize = 1024;
    protected long maxRows = 1024L;
    protected boolean escapeProcessing;
    protected int queryTimeout = 1000;
    protected String cursorName;
    protected int fetchDirection = 1;
    protected int fetchSize = 1;
    protected int resultSetConcurrency = 1;
    protected int resultSetType = 1;
    private int resultSetHoldability = 1;
    protected ResultSet resultSet;
    protected boolean sqlExceptionOnClose;

    public TesterStatement(Connection connection) {
        this.connection = connection;
    }

    public TesterStatement(Connection connection, int resultSetType, int resultSetConcurrency) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public TesterStatement(Connection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
    }

    protected void checkOpen() throws SQLException {
        if (!this.open) {
            throw new SQLException("Connection is closed.");
        }
    }

    protected void checkQueryTimeout() throws SQLTimeoutException {
        if (this.queryTimeout > 0 && this.queryTimeout < 5) {
            throw new SQLTimeoutException("query timeout " + this.queryTimeout);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public void close() throws SQLException {
        if (this.sqlExceptionOnClose) {
            throw new SQLException("TestSQLExceptionOnClose");
        }
        if (!this.open) {
            return;
        }
        this.open = false;
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        if ("invalid".equals(sql)) {
            throw new SQLException("invalid query");
        }
        return true;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        return new int[0];
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkOpen();
        return new long[0];
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.checkOpen();
        return 1L;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        switch (sql) {
            case "null": {
                return null;
            }
            case "invalid": {
                throw new SQLException("invalid query");
            }
            case "broken": {
                throw new SQLException("broken connection");
            }
            case "select username": {
                String userName = ((TesterConnection)this.connection).getUserName();
                Object[][] data = new Object[][]{{userName}};
                return new TesterResultSet(this, data);
            }
        }
        this.checkQueryTimeout();
        return new TesterResultSet(this);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return new TesterResultSet(this);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkOpen();
        return 1L;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return (int)this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        if (this.resultSet == null) {
            this.resultSet = new TesterResultSet(this);
        }
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return this.resultSetHoldability;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.open;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    public boolean isSqlExceptionOnClose() {
        return this.sqlExceptionOnClose;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        this.cursorName = name;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        this.escapeProcessing = enable;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        this.fetchSize = rows;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkOpen();
        this.maxRows = max;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        this.maxFieldSize = max;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        this.queryTimeout = seconds;
    }

    public void setSqlExceptionOnClose(boolean sqlExceptionOnClose) {
        this.sqlExceptionOnClose = sqlExceptionOnClose;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Not implemented.");
    }
}

