/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SetLiteralTest
extends JexlTestCase {
    private static Set<?> createSet(Object ... args) {
        return new HashSet<Object>(Arrays.asList(args));
    }

    public SetLiteralTest() {
        super("SetLiteralTest");
    }

    @Test
    void testLiteralWithOneEntry() throws Exception {
        List<String> sources = Arrays.asList("{ 'foo' }", "{ 'foo', }");
        for (String src : sources) {
            JexlExpression e = this.JEXL.createExpression(src);
            MapContext jc = new MapContext();
            Object o = e.evaluate((JexlContext)jc);
            Set<?> check = SetLiteralTest.createSet("foo");
            Assertions.assertEquals(check, (Object)o);
        }
    }

    @Test
    void testNotEmptySimpleSetLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("empty({ 'foo' , 'bar' })");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertFalse((boolean)((Boolean)o));
    }

    @Test
    void testSetLiteralWithNulls() throws Exception {
        String[] exprs = new String[]{"{  }", "{ 10 }", "{ 10 , null }", "{ 10 , null , 20}", "{ '10' , null }", "{ null, '10' , 20 }"};
        Set[] checks = new Set[]{Collections.emptySet(), SetLiteralTest.createSet(10), SetLiteralTest.createSet(10, null), SetLiteralTest.createSet(10, null, 20), SetLiteralTest.createSet("10", null), SetLiteralTest.createSet(null, "10", 20)};
        MapContext jc = new MapContext();
        for (int t = 0; t < exprs.length; ++t) {
            JexlScript e = this.JEXL.createScript(exprs[t]);
            Object o = e.execute((JexlContext)jc);
            Assertions.assertEquals((Object)checks[t], (Object)o, (String)exprs[t]);
        }
    }

    @Test
    void testSetLiteralWithNumbers() throws Exception {
        JexlExpression e = this.JEXL.createExpression("{ 5.0 , 10 }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Set<?> check = SetLiteralTest.createSet(5.0, 10);
        Assertions.assertEquals(check, (Object)o);
    }

    @Test
    void testSetLiteralWithOneEntryBlock() throws Exception {
        JexlScript e = this.JEXL.createScript("{ { 'foo' }; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Set<?> check = SetLiteralTest.createSet("foo");
        Assertions.assertEquals(check, (Object)o);
    }

    @Test
    void testSetLiteralWithOneEntryScript() throws Exception {
        JexlScript e = this.JEXL.createScript("{ 'foo' }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Set<?> check = SetLiteralTest.createSet("foo");
        Assertions.assertEquals(check, (Object)o);
    }

    @Test
    void testSetLiteralWithOneNestedSet() throws Exception {
        JexlScript e = this.JEXL.createScript("{ { 'foo' } }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Set<?> check = SetLiteralTest.createSet(SetLiteralTest.createSet("foo"));
        Assertions.assertEquals(check, (Object)o);
    }

    @Test
    void testSetLiteralWithStrings() throws Exception {
        List<String> sources = Arrays.asList("{ 'foo', 'bar' }", "{ 'foo', 'bar', ... }", "{ 'foo', 'bar', }");
        for (String src : sources) {
            JexlExpression e = this.JEXL.createExpression(src);
            MapContext jc = new MapContext();
            Object o = e.evaluate((JexlContext)jc);
            Set<?> check = SetLiteralTest.createSet("foo", "bar");
            Assertions.assertEquals(check, (Object)o);
        }
        Assertions.assertThrows(JexlException.Parsing.class, () -> this.JEXL.createExpression("{ , }"), (String)"syntax");
    }

    @Test
    void testSetLiteralWithStringsScript() throws Exception {
        JexlScript e = this.JEXL.createScript("{ 'foo' , 'bar' }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Set<?> check = SetLiteralTest.createSet("foo", "bar");
        Assertions.assertEquals(check, (Object)o);
    }

    @Test
    void testSizeOfSimpleSetLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("size({ 'foo' , 'bar'})");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)2, (Object)o);
    }
}

