/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow.spring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.transport.http_undertow.ThreadingParameters;
import org.apache.cxf.transport.http_undertow.UndertowHTTPServerEngineFactory;
import org.apache.cxf.transport.http_undertow.spring.UndertowSpringTypesFactory;
import org.apache.cxf.transports.http_undertow.configuration.TLSServerParametersIdentifiedType;
import org.apache.cxf.transports.http_undertow.configuration.ThreadingParametersIdentifiedType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class UndertowHTTPServerEngineFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    static final String HTTP_UNDERTOW_NS = "http://cxf.apache.org/transports/http-undertow/configuration";

    protected String resolveId(Element elem, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id = this.getIdOrName(elem);
        if (StringUtils.isEmpty((String)id)) {
            return UndertowHTTPServerEngineFactory.class.getName();
        }
        id = super.resolveId(elem, definition, ctx);
        if (!ctx.getRegistry().containsBeanDefinition(UndertowHTTPServerEngineFactory.class.getName())) {
            ctx.getRegistry().registerAlias(id, UndertowHTTPServerEngineFactory.class.getName());
        }
        return id;
    }

    public void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        String bus = element.getAttribute("bus");
        BeanDefinitionBuilder factbean = BeanDefinitionBuilder.rootBeanDefinition(UndertowSpringTypesFactory.class);
        ctx.getRegistry().registerBeanDefinition(UndertowSpringTypesFactory.class.getName(), (BeanDefinition)factbean.getBeanDefinition());
        try {
            if (StringUtils.isEmpty((String)bus)) {
                this.addBusWiringAttribute(bean, BusWiringType.CONSTRUCTOR);
            } else {
                bean.addConstructorArgReference(bus);
            }
            bean.addConstructorArgValue((Object)this.mapElementToJaxbBean(element, TLSServerParametersIdentifiedType.class, UndertowSpringTypesFactory.class, "createTLSServerParametersMap", new Object[0]));
            bean.addConstructorArgValue((Object)this.mapElementToJaxbBean(element, ThreadingParametersIdentifiedType.class, UndertowSpringTypesFactory.class, "createThreadingParametersMap", new Object[0]));
            List<Object> list = this.getRequiredElementsList(element, ctx, new QName(HTTP_UNDERTOW_NS, "engine"), bean);
            if (!list.isEmpty()) {
                bean.addPropertyValue("enginesList", list);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process configuration.", e);
        }
    }

    private List<Object> getRequiredElementsList(Element parent, ParserContext ctx, QName name, BeanDefinitionBuilder bean) {
        List elemList = DOMUtils.findAllElementsByTagNameNS((Element)parent, (String)name.getNamespaceURI(), (String)name.getLocalPart());
        ManagedList list = new ManagedList(elemList.size());
        list.setSource(ctx.extractSource((Object)parent));
        for (Element elem : elemList) {
            list.add(ctx.getDelegate().parsePropertySubElement(elem, (BeanDefinition)bean.getBeanDefinition()));
        }
        return list;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected Class<?> getBeanClass(Element arg0) {
        return SpringUndertowHTTPServerEngineFactory.class;
    }

    @NoJSR250Annotations(unlessNull={"bus"})
    public static class SpringUndertowHTTPServerEngineFactory
    extends UndertowHTTPServerEngineFactory
    implements ApplicationContextAware {
        public SpringUndertowHTTPServerEngineFactory() {
        }

        public SpringUndertowHTTPServerEngineFactory(Bus bus, Map<String, TLSServerParameters> tls, Map<String, ThreadingParameters> threading) {
            super(bus, tls, threading);
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.getBus() == null) {
                this.setBus(BusWiringBeanFactoryPostProcessor.addDefaultBus((ApplicationContext)ctx));
            }
        }
    }
}

