/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.PrivateEndPointConnectionsClient;
import com.azure.resourcemanager.datafactory.fluent.models.PrivateEndpointConnectionResourceInner;
import com.azure.resourcemanager.datafactory.implementation.PrivateEndpointConnectionResourceImpl;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.PrivateEndPointConnections;
import com.azure.resourcemanager.datafactory.models.PrivateEndpointConnectionResource;

public final class PrivateEndPointConnectionsImpl
implements PrivateEndPointConnections {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndPointConnectionsImpl.class);
    private final PrivateEndPointConnectionsClient innerClient;
    private final DataFactoryManager serviceManager;

    public PrivateEndPointConnectionsImpl(PrivateEndPointConnectionsClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PrivateEndpointConnectionResource> listByFactory(String resourceGroupName, String factoryName) {
        PagedIterable<PrivateEndpointConnectionResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName);
        return Utils.mapPage(inner, inner1 -> new PrivateEndpointConnectionResourceImpl((PrivateEndpointConnectionResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PrivateEndpointConnectionResource> listByFactory(String resourceGroupName, String factoryName, Context context) {
        PagedIterable<PrivateEndpointConnectionResourceInner> inner = this.serviceClient().listByFactory(resourceGroupName, factoryName, context);
        return Utils.mapPage(inner, inner1 -> new PrivateEndpointConnectionResourceImpl((PrivateEndpointConnectionResourceInner)((Object)inner1), this.manager()));
    }

    private PrivateEndPointConnectionsClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }
}

