/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.client.response;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oltu.oauth2.client.validator.OAuthClientValidator;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;

public abstract class OAuthClientResponse {
    protected String body;
    protected String contentType;
    protected int responseCode;
    protected Map<String, List<String>> headers;
    protected OAuthClientValidator validator;
    protected Map<String, Object> parameters = new HashMap<String, Object>();

    public String getParam(String param) {
        Object value = this.parameters.get(param);
        return value == null ? null : String.valueOf(value);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    protected void setBody(String body) throws OAuthProblemException {
        throw new UnsupportedOperationException();
    }

    protected void setBody(InputStream body) throws OAuthProblemException {
        throw new UnsupportedOperationException();
    }

    protected abstract void setContentType(String var1);

    protected abstract void setResponseCode(int var1);

    protected void init(String body, String contentType, int responseCode, Map<String, List<String>> headers) throws OAuthProblemException {
        this.setBody(body);
        this.setContentType(contentType);
        this.setResponseCode(responseCode);
        this.setHeaders(headers);
        this.validate();
    }

    protected void init(String body, String contentType, int responseCode) throws OAuthProblemException {
        this.init(body, contentType, responseCode, new HashMap<String, List<String>>());
    }

    protected void init(InputStream body, String contentType, int responseCode, Map<String, List<String>> headers) throws OAuthProblemException {
        try {
            this.init(OAuthUtils.saveStreamAsString(body), contentType, responseCode);
        }
        catch (IOException e) {
            throw OAuthProblemException.error(e.getMessage());
        }
    }

    protected void validate() throws OAuthProblemException {
        this.validator.validate(this);
    }
}

