/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.engine.ILifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.AbstractTaskLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.TaskLifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;

public class TaskTimeoutLifecycleEvent
extends AbstractTaskLifecycleEvent {
    private final ITaskExecutionRunnable taskExecutionRunnable;

    protected TaskTimeoutLifecycleEvent(ITaskExecutionRunnable taskExecutionRunnable, long timeout) {
        super(timeout);
        this.taskExecutionRunnable = taskExecutionRunnable;
    }

    public static TaskTimeoutLifecycleEvent of(ITaskExecutionRunnable taskExecutionRunnable) {
        TaskDefinition taskDefinition = taskExecutionRunnable.getTaskDefinition();
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        Preconditions.checkState((taskDefinition != null ? 1 : 0) != 0, (Object)"The task instance must be initialized before retrying.");
        int timeout = taskDefinition.getTimeout();
        Preconditions.checkState((timeout >= 0 ? 1 : 0) != 0, (String)"The task timeout: %s must >=0 minutes", (int)timeout);
        long delayTime = System.currentTimeMillis() - taskInstance.getSubmitTime().getTime() + TimeUnit.MINUTES.toMillis(timeout);
        return new TaskTimeoutLifecycleEvent(taskExecutionRunnable, delayTime);
    }

    @Override
    public ILifecycleEventType getEventType() {
        return TaskLifecycleEventType.TIMEOUT;
    }

    public String toString() {
        return "TaskRetryEvent{task=" + this.taskExecutionRunnable.getName() + ", timeout=" + this.delayTime + '}';
    }

    @Override
    @Generated
    public ITaskExecutionRunnable getTaskExecutionRunnable() {
        return this.taskExecutionRunnable;
    }
}

