/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.ServerAutomaticTuningInner;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.AutomaticTuningOptionModeDesired;
import com.azure.resourcemanager.sql.models.AutomaticTuningServerMode;
import com.azure.resourcemanager.sql.models.AutomaticTuningServerOptions;
import com.azure.resourcemanager.sql.models.SqlServerAutomaticTuning;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import reactor.core.publisher.Mono;

public class SqlServerAutomaticTuningImpl
extends RefreshableWrapperImpl<ServerAutomaticTuningInner, SqlServerAutomaticTuning>
implements SqlServerAutomaticTuning,
SqlServerAutomaticTuning.Update {
    protected String key;
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlServerAutomaticTuningImpl(SqlServerImpl server, ServerAutomaticTuningInner innerObject) {
        this(server.resourceGroupName(), server.name(), innerObject, (SqlServerManager)server.manager());
    }

    SqlServerAutomaticTuningImpl(String resourceGroupName, String sqlServerName, ServerAutomaticTuningInner innerObject, SqlServerManager sqlServerManager) {
        super((Object)innerObject);
        Objects.requireNonNull(innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.key = UUID.randomUUID().toString();
    }

    public String key() {
        return this.key;
    }

    @Override
    public AutomaticTuningServerMode desiredState() {
        return ((ServerAutomaticTuningInner)((Object)this.innerModel())).desiredState();
    }

    @Override
    public AutomaticTuningServerMode actualState() {
        return ((ServerAutomaticTuningInner)((Object)this.innerModel())).actualState();
    }

    @Override
    public Map<String, AutomaticTuningServerOptions> tuningOptions() {
        return Collections.unmodifiableMap(((ServerAutomaticTuningInner)((Object)this.innerModel())).options() != null ? ((ServerAutomaticTuningInner)((Object)this.innerModel())).options() : new HashMap());
    }

    @Override
    public SqlServerAutomaticTuningImpl withAutomaticTuningMode(AutomaticTuningServerMode desiredState) {
        ((ServerAutomaticTuningInner)((Object)this.innerModel())).withDesiredState(desiredState);
        return this;
    }

    @Override
    public SqlServerAutomaticTuningImpl withAutomaticTuningOption(String tuningOptionName, AutomaticTuningOptionModeDesired desiredState) {
        if (((ServerAutomaticTuningInner)((Object)this.innerModel())).options() == null) {
            ((ServerAutomaticTuningInner)((Object)this.innerModel())).withOptions(new HashMap<String, AutomaticTuningServerOptions>());
        }
        AutomaticTuningServerOptions item = ((ServerAutomaticTuningInner)((Object)this.innerModel())).options().get(tuningOptionName);
        ((ServerAutomaticTuningInner)((Object)this.innerModel())).options().put(tuningOptionName, item != null ? item.withDesiredState(desiredState) : new AutomaticTuningServerOptions().withDesiredState(desiredState));
        return this;
    }

    @Override
    public SqlServerAutomaticTuningImpl withAutomaticTuningOptions(Map<String, AutomaticTuningOptionModeDesired> tuningOptions) {
        if (tuningOptions != null) {
            for (Map.Entry<String, AutomaticTuningOptionModeDesired> option : tuningOptions.entrySet()) {
                this.withAutomaticTuningOption(option.getKey(), option.getValue());
            }
        }
        return this;
    }

    protected Mono<ServerAutomaticTuningInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerAutomaticTunings().getAsync(this.resourceGroupName, this.sqlServerName);
    }

    public SqlServerAutomaticTuning apply() {
        return (SqlServerAutomaticTuning)this.applyAsync().block();
    }

    public Mono<SqlServerAutomaticTuning> applyAsync() {
        return this.applyAsync(Context.NONE);
    }

    public SqlServerAutomaticTuning apply(Context context) {
        return (SqlServerAutomaticTuning)this.applyAsync(context).block();
    }

    public Mono<SqlServerAutomaticTuning> applyAsync(Context context) {
        SqlServerAutomaticTuningImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerAutomaticTunings().updateAsync(this.resourceGroupName, this.sqlServerName, (ServerAutomaticTuningInner)((Object)this.innerModel())).contextWrite(c -> c.putAll(FluxUtil.toReactorContext((Context)context).readOnly())).map(serverAutomaticTuningInner -> {
            self.setInner(serverAutomaticTuningInner);
            return self;
        });
    }

    public SqlServerAutomaticTuning.Update update() {
        return this;
    }
}

