/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model.select;

import com.obs.services.internal.xml.OBSXMLBuilder;
import com.obs.services.model.select.FileHeaderInfo;
import com.obs.services.model.select.XmlSerialization;

public class CsvInput
extends XmlSerialization {
    private Boolean allowQuotedRecordDelimiter;
    private Character comments;
    private Character fieldDelimiter;
    private String fileHeaderInfo;
    private Character quoteCharacter;
    private Character quoteEscapeCharacter;
    private Character recordDelimiter;

    public CsvInput withAllowQuotedRecordDelimiter(boolean allowQuotedRecordDelimiter) {
        this.allowQuotedRecordDelimiter = allowQuotedRecordDelimiter;
        return this;
    }

    public CsvInput withComments(char comments) {
        this.comments = Character.valueOf(comments);
        return this;
    }

    public CsvInput withFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = Character.valueOf(fieldDelimiter);
        return this;
    }

    public CsvInput withRecordDelimiter(char recordDelimiter) {
        this.recordDelimiter = Character.valueOf(recordDelimiter);
        return this;
    }

    public CsvInput withFileHeaderInfo(FileHeaderInfo fileHeaderInfo) {
        this.fileHeaderInfo = fileHeaderInfo.toString();
        return this;
    }

    public CsvInput withQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = Character.valueOf(quoteCharacter);
        return this;
    }

    public CsvInput withQuoteEscapeCharacter(char quoteEscapeCharacter) {
        this.quoteEscapeCharacter = Character.valueOf(quoteEscapeCharacter);
        return this;
    }

    @Override
    public void appendToXml(OBSXMLBuilder xmlBuilder) {
        OBSXMLBuilder csvBuilder = xmlBuilder.elem("CSV");
        if (this.allowQuotedRecordDelimiter != null) {
            csvBuilder.elem("allowQuotedRecordDelimiter").text(this.allowQuotedRecordDelimiter.toString());
        }
        if (this.comments != null) {
            csvBuilder.elem("Comments").text(this.charToString(this.comments));
        }
        if (this.fieldDelimiter != null) {
            csvBuilder.elem("FieldDelimiter").text(this.charToString(this.fieldDelimiter));
        }
        if (this.recordDelimiter != null) {
            csvBuilder.elem("RecordDelimiter").text(this.charToString(this.recordDelimiter));
        }
        if (this.fileHeaderInfo != null) {
            csvBuilder.elem("FileHeaderInfo").text(this.fileHeaderInfo);
        }
        if (this.quoteCharacter != null) {
            csvBuilder.elem("QuoteCharacter").text(this.charToString(this.quoteCharacter));
        }
        if (this.quoteEscapeCharacter != null) {
            csvBuilder.elem("QuoteEscapeCharacter").text(this.charToString(this.quoteEscapeCharacter));
        }
    }
}

