/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public enum AuditModelType {
    PROJECT("Project", null),
    WORKFLOW("Workflow", PROJECT),
    WORKFLOW_INSTANCE("WorkflowInstance", WORKFLOW),
    TASK("Task", WORKFLOW),
    TASK_INSTANCE("TaskInstance", TASK),
    SCHEDULE("Schedule", WORKFLOW),
    RESOURCE("Resource", null),
    FOLDER("Folder", RESOURCE),
    FILE("File", FOLDER),
    TASK_GROUP("TaskGroup", RESOURCE),
    DATASOURCE("Datasource", null),
    SECURITY("Security", null),
    TENANT("Tenant", SECURITY),
    USER("User", SECURITY),
    ALARM_GROUP("AlarmGroup", SECURITY),
    ALARM_INSTANCE("AlarmInstance", SECURITY),
    WORKER_GROUP("WorkerGroup", SECURITY),
    YARN_QUEUE("YarnQueue", SECURITY),
    ENVIRONMENT("Environment", SECURITY),
    CLUSTER("Cluster", SECURITY),
    K8S_NAMESPACE("K8sNamespace", SECURITY),
    TOKEN("Token", SECURITY);

    private final String name;
    private final AuditModelType parentType;
    private final List<AuditModelType> child = new ArrayList<AuditModelType>();
    private static final HashMap<String, AuditModelType> AUDIT_MODEL_MAP;
    private static final List<AuditModelType> AUDIT_MODEL_TREE_LIST;

    public static List<AuditModelType> getAuditModelTreeList() {
        return AUDIT_MODEL_TREE_LIST;
    }

    public static AuditModelType of(String name) {
        if (AUDIT_MODEL_MAP.containsKey(name)) {
            return AUDIT_MODEL_MAP.get(name);
        }
        throw new IllegalArgumentException("invalid audit operation type name " + name);
    }

    private AuditModelType(String name, AuditModelType parentType) {
        this.name = name;
        this.parentType = parentType;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public AuditModelType getParentType() {
        return this.parentType;
    }

    @Generated
    public List<AuditModelType> getChild() {
        return this.child;
    }

    static {
        AUDIT_MODEL_MAP = new HashMap();
        AUDIT_MODEL_TREE_LIST = new ArrayList<AuditModelType>();
        for (AuditModelType auditModelType : AuditModelType.values()) {
            AUDIT_MODEL_MAP.put(auditModelType.name, auditModelType);
        }
        for (AuditModelType auditModelType : AuditModelType.values()) {
            if (auditModelType.parentType != null) {
                AuditModelType.of((String)auditModelType.parentType.name).child.add(auditModelType);
                continue;
            }
            AUDIT_MODEL_TREE_LIST.add(auditModelType);
        }
    }
}

