/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.alert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.AlertType;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowAlertContent;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.ProjectDao;
import org.apache.dolphinscheduler.dao.repository.UserDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionLogDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowAlertManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowAlertManager.class);
    @Autowired
    private AlertDao alertDao;
    @Autowired
    private WorkflowDefinitionLogDao workflowDefinitionLogDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private ProjectDao projectDao;

    private String getCommandCnName(CommandType commandType) {
        switch (commandType) {
            case RECOVER_TOLERANCE_FAULT_PROCESS: {
                return "recover fault tolerance workflow";
            }
            case RECOVER_SUSPENDED_PROCESS: {
                return "recover suspended workflow";
            }
            case START_CURRENT_TASK_PROCESS: {
                return "start current task workflow";
            }
            case START_FAILURE_TASK_PROCESS: {
                return "start failure task workflow";
            }
            case START_PROCESS: {
                return "start workflow";
            }
            case REPEAT_RUNNING: {
                return "repeat running";
            }
            case SCHEDULER: {
                return "scheduler";
            }
            case COMPLEMENT_DATA: {
                return "complement data";
            }
            case PAUSE: {
                return "pause";
            }
            case STOP: {
                return "stop";
            }
        }
        return "unknown type";
    }

    public String getContentWorkflowInstance(WorkflowInstance workflowInstance, Project project) {
        WorkflowDefinitionLog workflowDefinitionLog = this.workflowDefinitionLogDao.queryByDefinitionCodeAndVersion(workflowInstance.getWorkflowDefinitionCode().longValue(), workflowInstance.getWorkflowDefinitionVersion());
        String modifyBy = "";
        if (workflowDefinitionLog != null) {
            User operator = (User)this.userDao.queryById((Serializable)Integer.valueOf(workflowDefinitionLog.getOperator()));
            modifyBy = operator == null ? "" : operator.getUserName();
        }
        ArrayList<WorkflowAlertContent> successTaskList = new ArrayList<WorkflowAlertContent>(1);
        WorkflowAlertContent workflowAlertContent = WorkflowAlertContent.builder().projectCode(Long.valueOf(project.getCode())).projectName(project.getName()).owner(project.getUserName()).workflowInstanceId(workflowInstance.getId()).workflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode()).workflowInstanceName(workflowInstance.getName()).commandType(workflowInstance.getCommandType()).workflowExecutionStatus(workflowInstance.getState()).modifyBy(modifyBy).recovery(workflowInstance.getRecovery()).runTimes(Integer.valueOf(workflowInstance.getRunTimes())).workflowStartTime(workflowInstance.getStartTime()).workflowEndTime(workflowInstance.getEndTime()).workflowHost(workflowInstance.getHost()).build();
        successTaskList.add(workflowAlertContent);
        String res = JSONUtils.toJsonString(successTaskList);
        return res;
    }

    private String getWorkerToleranceContent(WorkflowInstance workflowInstance, List<TaskInstance> toleranceTaskList) {
        ArrayList<WorkflowAlertContent> toleranceTaskInstanceList = new ArrayList<WorkflowAlertContent>();
        WorkflowDefinitionLog workflowDefinitionLog = this.workflowDefinitionLogDao.queryByDefinitionCodeAndVersion(workflowInstance.getWorkflowDefinitionCode().longValue(), workflowInstance.getWorkflowDefinitionVersion());
        String modifyBy = "";
        if (workflowDefinitionLog != null) {
            User operator = (User)this.userDao.queryById((Serializable)Integer.valueOf(workflowDefinitionLog.getOperator()));
            modifyBy = operator == null ? "" : operator.getUserName();
        }
        for (TaskInstance taskInstance : toleranceTaskList) {
            WorkflowAlertContent workflowAlertContent = WorkflowAlertContent.builder().workflowInstanceId(workflowInstance.getId()).workflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode()).workflowInstanceName(workflowInstance.getName()).modifyBy(modifyBy).taskCode(Long.valueOf(taskInstance.getTaskCode())).taskName(taskInstance.getName()).taskHost(taskInstance.getHost()).taskPriority(taskInstance.getTaskInstancePriority().getDescp()).retryTimes(Integer.valueOf(taskInstance.getRetryTimes())).build();
            toleranceTaskInstanceList.add(workflowAlertContent);
        }
        return JSONUtils.toJsonString(toleranceTaskInstanceList);
    }

    public void sendAlertWorkerToleranceFault(WorkflowInstance workflowInstance, List<TaskInstance> toleranceTaskList) {
        try {
            Alert alert = new Alert();
            alert.setTitle("worker fault tolerance");
            String content = this.getWorkerToleranceContent(workflowInstance, toleranceTaskList);
            alert.setContent(content);
            alert.setWarningType(WarningType.FAILURE);
            alert.setCreateTime(new Date());
            alert.setAlertGroupId(Integer.valueOf(workflowInstance.getWarningGroupId() == null ? 1 : workflowInstance.getWarningGroupId()));
            alert.setAlertType(AlertType.FAULT_TOLERANCE_WARNING);
            this.alertDao.addAlert(alert);
        }
        catch (Exception e) {
            log.error("send alert failed:{} ", (Object)e.getMessage());
        }
    }

    public void sendAlertWorkflowInstance(WorkflowInstance workflowInstance) {
        if (!this.isNeedToSendWarning(workflowInstance)) {
            return;
        }
        Project project = this.projectDao.queryByCode(workflowInstance.getProjectCode());
        Alert alert = new Alert();
        String cmdName = this.getCommandCnName(workflowInstance.getCommandType());
        String success = workflowInstance.getState().isSuccess() ? "success" : "failed";
        alert.setTitle(cmdName + " " + success);
        alert.setWarningType(workflowInstance.getState().isSuccess() ? WarningType.SUCCESS : WarningType.FAILURE);
        String content = this.getContentWorkflowInstance(workflowInstance, project);
        alert.setContent(content);
        alert.setAlertGroupId(workflowInstance.getWarningGroupId());
        alert.setCreateTime(new Date());
        alert.setProjectCode(workflowInstance.getProjectCode());
        alert.setWorkflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode());
        alert.setWorkflowInstanceId(workflowInstance.getId());
        alert.setAlertType(workflowInstance.getState().isSuccess() ? AlertType.WORKFLOW_INSTANCE_SUCCESS : AlertType.WORKFLOW_INSTANCE_FAILURE);
        this.alertDao.addAlert(alert);
    }

    public boolean isNeedToSendWarning(WorkflowInstance workflowInstance) {
        if (Flag.YES == workflowInstance.getIsSubWorkflow()) {
            return false;
        }
        boolean sendWarning = false;
        WarningType warningType = workflowInstance.getWarningType();
        switch (warningType) {
            case ALL: {
                if (!workflowInstance.getState().isFinalState()) break;
                sendWarning = true;
                break;
            }
            case SUCCESS: {
                if (!workflowInstance.getState().isSuccess()) break;
                sendWarning = true;
                break;
            }
            case FAILURE: {
                if (!workflowInstance.getState().isFailure()) break;
                sendWarning = true;
                break;
            }
        }
        return sendWarning;
    }

    public void sendTaskTimeoutAlert(WorkflowInstance workflowInstance, TaskInstance taskInstance, ProjectUser projectUser) {
        this.alertDao.sendTaskTimeoutAlert(workflowInstance, taskInstance, projectUser);
    }
}

