/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.log.remote;

import lombok.Generated;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogHandler;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogHandlerFactory;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class RemoteLogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteLogService.class);

    @Async(value="remoteLogHandleExecutor")
    public void asyncSendRemoteLog(String logPath) {
        if (RemoteLogUtils.isRemoteLoggingEnable()) {
            log.info("Start to send log {} to remote target {}", (Object)logPath, (Object)PropertyUtils.getString("remote.logging.target"));
            RemoteLogHandler remoteLogHandler = RemoteLogHandlerFactory.getRemoteLogHandler();
            if (remoteLogHandler == null) {
                return;
            }
            remoteLogHandler.sendRemoteLog(logPath);
            log.info("End send log {} to remote target {}", (Object)logPath, (Object)PropertyUtils.getString("remote.logging.target"));
        }
    }
}

