/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceRule is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.")
public class V1ResourceRule {
    public static final String SERIALIZED_NAME_API_GROUPS = "apiGroups";
    @SerializedName(value="apiGroups")
    private List<String> apiGroups = null;
    public static final String SERIALIZED_NAME_RESOURCE_NAMES = "resourceNames";
    @SerializedName(value="resourceNames")
    private List<String> resourceNames = null;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private List<String> resources = null;
    public static final String SERIALIZED_NAME_VERBS = "verbs";
    @SerializedName(value="verbs")
    private List<String> verbs = new ArrayList<String>();

    public V1ResourceRule apiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public V1ResourceRule addApiGroupsItem(String apiGroupsItem) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.  \"*\" means all.")
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public V1ResourceRule resourceNames(List<String> resourceNames) {
        this.resourceNames = resourceNames;
        return this;
    }

    public V1ResourceRule addResourceNamesItem(String resourceNamesItem) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(resourceNamesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.  \"*\" means all.")
    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public void setResourceNames(List<String> resourceNames) {
        this.resourceNames = resourceNames;
    }

    public V1ResourceRule resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public V1ResourceRule addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resources is a list of resources this rule applies to.  \"*\" means all in the specified apiGroups.  \"*_/foo\" represents the subresource 'foo' for all resources in the specified apiGroups.")
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public V1ResourceRule verbs(List<String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public V1ResourceRule addVerbsItem(String verbsItem) {
        this.verbs.add(verbsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Verb is a list of kubernetes resource API verbs, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.")
    public List<String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<String> verbs) {
        this.verbs = verbs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceRule v1ResourceRule = (V1ResourceRule)o;
        return Objects.equals(this.apiGroups, v1ResourceRule.apiGroups) && Objects.equals(this.resourceNames, v1ResourceRule.resourceNames) && Objects.equals(this.resources, v1ResourceRule.resources) && Objects.equals(this.verbs, v1ResourceRule.verbs);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.resourceNames, this.resources, this.verbs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceRule {\n");
        sb.append("    apiGroups: ").append(this.toIndentedString(this.apiGroups)).append("\n");
        sb.append("    resourceNames: ").append(this.toIndentedString(this.resourceNames)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    verbs: ").append(this.toIndentedString(this.verbs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

