/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.dolphinscheduler.common.enums.AlertEvent;
import org.apache.dolphinscheduler.common.enums.AlertStatus;
import org.apache.dolphinscheduler.common.enums.AlertType;
import org.apache.dolphinscheduler.common.enums.AlertWarnLevel;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.AlertPluginInstance;
import org.apache.dolphinscheduler.dao.entity.AlertSendStatus;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.ServerAlertContent;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowAlertContent;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertPluginInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertSendStatusMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AlertDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertDao.class);
    private static final Integer QUERY_ALERT_THRESHOLD = 100;
    private static final int ADMIN_ALERT_GROUP_ID = 1;
    @Value(value="${alert.alarm-suppression.crash:60}")
    private Integer crashAlarmSuppression;
    @Autowired
    private AlertMapper alertMapper;
    @Autowired
    private AlertPluginInstanceMapper alertPluginInstanceMapper;
    @Autowired
    private AlertGroupMapper alertGroupMapper;
    @Autowired
    private AlertSendStatusMapper alertSendStatusMapper;

    public int addAlert(Alert alert) {
        if (null == alert.getAlertGroupId() || NumberUtils.INTEGER_ZERO.equals(alert.getAlertGroupId())) {
            log.warn("the value of alertGroupId is null or 0 ");
            return 0;
        }
        String sign = this.generateSign(alert);
        alert.setSign(sign);
        int count = this.alertMapper.insert(alert);
        log.info("add alert to db , alert: {}", (Object)alert);
        return count;
    }

    public int updateAlert(AlertStatus alertStatus, String log, int id) {
        Alert alert = new Alert();
        alert.setId(id);
        alert.setAlertStatus(alertStatus);
        alert.setUpdateTime(new Date());
        alert.setLog(log);
        return this.alertMapper.updateById(alert);
    }

    private String generateSign(Alert alert) {
        return Optional.of(alert).map(Alert::getContent).map(DigestUtils::sha1Hex).map(String::toLowerCase).orElse("");
    }

    public int addAlertSendStatus(AlertStatus sendStatus, String log, int alertId, int alertPluginInstanceId) {
        AlertSendStatus alertSendStatus = new AlertSendStatus();
        alertSendStatus.setAlertId(alertId);
        alertSendStatus.setAlertPluginInstanceId(alertPluginInstanceId);
        alertSendStatus.setSendStatus(sendStatus);
        alertSendStatus.setLog(log);
        alertSendStatus.setCreateTime(new Date());
        return this.alertSendStatusMapper.insert(alertSendStatus);
    }

    public int insertAlertSendStatus(List<AlertSendStatus> alertSendStatuses) {
        if (CollectionUtils.isEmpty(alertSendStatuses)) {
            return 0;
        }
        return this.alertSendStatusMapper.batchInsert(alertSendStatuses);
    }

    public void sendServerStoppedAlert(String host, String serverType) {
        ServerAlertContent serverStopAlertContent = ServerAlertContent.newBuilder().type(serverType).host(host).event(AlertEvent.SERVER_DOWN).warningLevel(AlertWarnLevel.SERIOUS).build();
        String content = JSONUtils.toJsonString((Object)Lists.newArrayList((Object[])new ServerAlertContent[]{serverStopAlertContent}));
        Alert alert = new Alert();
        alert.setTitle("Fault tolerance warning");
        alert.setWarningType(WarningType.FAILURE);
        alert.setAlertStatus(AlertStatus.WAIT_EXECUTION);
        alert.setContent(content);
        alert.setAlertGroupId(1);
        alert.setCreateTime(new Date());
        alert.setUpdateTime(new Date());
        alert.setAlertType(AlertType.FAULT_TOLERANCE_WARNING);
        alert.setSign(this.generateSign(alert));
        Date crashAlarmSuppressionStartTime = Date.from(LocalDateTime.now().plusMinutes(-this.crashAlarmSuppression.intValue()).atZone(ZoneId.systemDefault()).toInstant());
        this.alertMapper.insertAlertWhenServerCrash(alert, crashAlarmSuppressionStartTime);
    }

    public void sendWorkflowTimeoutAlert(WorkflowInstance workflowInstance, ProjectUser projectUser) {
        int alertGroupId = workflowInstance.getWarningGroupId();
        Alert alert = new Alert();
        ArrayList<WorkflowAlertContent> workflowAlertContentList = new ArrayList<WorkflowAlertContent>(1);
        WorkflowAlertContent workflowAlertContent = WorkflowAlertContent.builder().projectCode(projectUser.getProjectCode()).projectName(projectUser.getProjectName()).owner(projectUser.getUserName()).workflowInstanceId(workflowInstance.getId()).workflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode()).workflowInstanceName(workflowInstance.getName()).commandType(workflowInstance.getCommandType()).workflowExecutionStatus(workflowInstance.getState()).runTimes(workflowInstance.getRunTimes()).workflowStartTime(workflowInstance.getStartTime()).workflowHost(workflowInstance.getHost()).event(AlertEvent.TIME_OUT).warnLevel(AlertWarnLevel.MIDDLE).build();
        workflowAlertContentList.add(workflowAlertContent);
        String content = JSONUtils.toJsonString(workflowAlertContentList);
        alert.setTitle("Workflow Timeout Warn");
        alert.setProjectCode(projectUser.getProjectCode());
        alert.setWorkflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode());
        alert.setWorkflowInstanceId(workflowInstance.getId());
        alert.setAlertType(AlertType.WORKFLOW_INSTANCE_TIMEOUT);
        this.saveTaskTimeoutAlert(alert, content, alertGroupId);
    }

    private void saveTaskTimeoutAlert(Alert alert, String content, int alertGroupId) {
        alert.setAlertGroupId(alertGroupId);
        alert.setWarningType(WarningType.FAILURE);
        alert.setContent(content);
        alert.setCreateTime(new Date());
        alert.setUpdateTime(new Date());
        String sign = this.generateSign(alert);
        alert.setSign(sign);
        this.alertMapper.insert(alert);
    }

    public void sendTaskTimeoutAlert(WorkflowInstance workflowInstance, TaskInstance taskInstance, ProjectUser projectUser) {
        Alert alert = new Alert();
        ArrayList<WorkflowAlertContent> workflowAlertContentList = new ArrayList<WorkflowAlertContent>(1);
        WorkflowAlertContent workflowAlertContent = WorkflowAlertContent.builder().projectCode(projectUser.getProjectCode()).projectName(projectUser.getProjectName()).owner(projectUser.getUserName()).workflowInstanceId(workflowInstance.getId()).workflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode()).workflowInstanceName(workflowInstance.getName()).taskCode(taskInstance.getTaskCode()).taskName(taskInstance.getName()).taskType(taskInstance.getTaskType()).taskStartTime(taskInstance.getStartTime()).taskHost(taskInstance.getHost()).event(AlertEvent.TIME_OUT).warnLevel(AlertWarnLevel.MIDDLE).build();
        workflowAlertContentList.add(workflowAlertContent);
        String content = JSONUtils.toJsonString(workflowAlertContentList);
        alert.setTitle("Task Timeout Warn");
        alert.setProjectCode(projectUser.getProjectCode());
        alert.setWorkflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode());
        alert.setWorkflowInstanceId(workflowInstance.getId());
        alert.setAlertType(AlertType.TASK_TIMEOUT);
        this.saveTaskTimeoutAlert(alert, content, workflowInstance.getWarningGroupId());
    }

    public List<Alert> listPendingAlerts(int minAlertId) {
        return this.alertMapper.listingAlertByStatus(minAlertId, AlertStatus.WAIT_EXECUTION.getCode(), QUERY_ALERT_THRESHOLD);
    }

    public List<Alert> listAlerts(int workflowInstanceId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Alert::getWorkflowInstanceId, (Object)workflowInstanceId);
        return this.alertMapper.selectList((Wrapper)wrapper);
    }

    public List<AlertPluginInstance> listInstanceByAlertGroupId(int alertGroupId) {
        String alertInstanceIdsParam = this.alertGroupMapper.queryAlertGroupInstanceIdsById(alertGroupId);
        if (!Strings.isNullOrEmpty((String)alertInstanceIdsParam)) {
            String[] idsArray = alertInstanceIdsParam.split(",");
            List<Integer> ids = Arrays.stream(idsArray).map(s -> Integer.parseInt(s.trim())).collect(Collectors.toList());
            return this.alertPluginInstanceMapper.queryByIds(ids);
        }
        return null;
    }

    public AlertPluginInstanceMapper getAlertPluginInstanceMapper() {
        return this.alertPluginInstanceMapper;
    }

    public void setAlertPluginInstanceMapper(AlertPluginInstanceMapper alertPluginInstanceMapper) {
        this.alertPluginInstanceMapper = alertPluginInstanceMapper;
    }

    public AlertGroupMapper getAlertGroupMapper() {
        return this.alertGroupMapper;
    }

    public void setAlertGroupMapper(AlertGroupMapper alertGroupMapper) {
        this.alertGroupMapper = alertGroupMapper;
    }

    public void setCrashAlarmSuppression(Integer crashAlarmSuppression) {
        this.crashAlarmSuppression = crashAlarmSuppression;
    }

    public void deleteByWorkflowInstanceId(Integer workflowInstanceId) {
        if (workflowInstanceId == null) {
            return;
        }
        List<Alert> alertList = this.alertMapper.selectByWorkflowInstanceId(workflowInstanceId);
        if (CollectionUtils.isEmpty(alertList)) {
            return;
        }
        this.alertMapper.deleteByWorkflowInstanceId(workflowInstanceId);
        List<Integer> alertIds = alertList.stream().map(Alert::getId).collect(Collectors.toList());
        this.alertSendStatusMapper.deleteByAlertIds(alertIds);
    }
}

