/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.exception;

import com.azure.core.management.exception.ManagementException;
import java.util.Arrays;
import java.util.Optional;

public final class AggregatedManagementException
extends ManagementException {
    private AggregatedManagementException(RuntimeException aggregatedException, ManagementException firstManagementException) {
        super(aggregatedException.getMessage(), firstManagementException.getResponse(), firstManagementException.getValue());
        for (Throwable exception : aggregatedException.getSuppressed()) {
            this.addSuppressed(exception);
        }
    }

    public static Throwable convertToManagementException(Throwable exception) {
        if (exception instanceof ManagementException || !(exception instanceof RuntimeException)) {
            return exception;
        }
        Optional<ManagementException> firstManagementException = Arrays.stream(exception.getSuppressed()).filter(e -> e instanceof ManagementException).map(e -> (ManagementException)e).findFirst();
        if (firstManagementException.isPresent()) {
            return new AggregatedManagementException((RuntimeException)exception, firstManagementException.get());
        }
        return exception;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        boolean skipException = true;
        for (Throwable exception : this.getSuppressed()) {
            ManagementException managementException;
            if (!(exception instanceof ManagementException)) continue;
            if (!skipException && (managementException = (ManagementException)exception).getValue() != null && managementException.getValue().getMessage() != null) {
                builder.append("; ").append(managementException.getValue().getMessage());
            }
            skipException = false;
        }
        return builder.toString();
    }
}

