/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.authentication.aws;

import java.util.Optional;
import lombok.Generated;

public enum AWSCredentialsProviderType {
    STATIC_CREDENTIALS_PROVIDER("AWSStaticCredentialsProvider"),
    INSTANCE_PROFILE_CREDENTIALS_PROVIDER("InstanceProfileCredentialsProvider");

    private final String name;

    private AWSCredentialsProviderType(String name) {
        this.name = name;
    }

    public static Optional<AWSCredentialsProviderType> of(String name) {
        if (name == null) {
            return Optional.empty();
        }
        for (AWSCredentialsProviderType type : AWSCredentialsProviderType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

