/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceCertificateOrderInner;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceCertificateResourceInner;
import com.azure.resourcemanager.appservice.implementation.AppServiceCertificateKeyVaultBindingImpl;
import com.azure.resourcemanager.appservice.models.AppServiceCertificateKeyVaultBinding;
import com.azure.resourcemanager.appservice.models.AppServiceCertificateOrder;
import com.azure.resourcemanager.appservice.models.AppServiceDomain;
import com.azure.resourcemanager.appservice.models.CertificateDetails;
import com.azure.resourcemanager.appservice.models.CertificateOrderStatus;
import com.azure.resourcemanager.appservice.models.CertificateProductType;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.keyvault.models.SecretPermissions;
import com.azure.resourcemanager.keyvault.models.Vault;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.time.OffsetDateTime;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class AppServiceCertificateOrderImpl
extends GroupableResourceImpl<AppServiceCertificateOrder, AppServiceCertificateOrderInner, AppServiceCertificateOrderImpl, AppServiceManager>
implements AppServiceCertificateOrder,
AppServiceCertificateOrder.Definition,
AppServiceCertificateOrder.Update {
    private WebAppBase domainVerifyWebApp;
    private AppServiceDomain domainVerifyDomain;
    private Mono<Vault> bindingVault;

    AppServiceCertificateOrderImpl(String key, AppServiceCertificateOrderInner innerObject, AppServiceManager manager) {
        super(key, (Resource)innerObject, (Manager)manager);
        ((AppServiceCertificateOrderImpl)this.withRegion("global")).withValidYears(1);
    }

    protected Mono<AppServiceCertificateOrderInner> getInnerAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServiceCertificateOrders().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public AppServiceCertificateKeyVaultBinding getKeyVaultBinding() {
        return (AppServiceCertificateKeyVaultBinding)this.getKeyVaultBindingAsync().block();
    }

    @Override
    public Mono<AppServiceCertificateKeyVaultBinding> getKeyVaultBindingAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServiceCertificateOrders().listCertificatesAsync(this.resourceGroupName(), this.name()).switchIfEmpty((Publisher)Mono.empty()).take(1L).singleOrEmpty().map(inner -> new AppServiceCertificateKeyVaultBindingImpl((AppServiceCertificateResourceInner)((Object)inner), this));
    }

    @Override
    public void verifyDomainOwnership(AppServiceDomain domain) {
        this.verifyDomainOwnershipAsync(domain).block();
    }

    @Override
    public Mono<Void> verifyDomainOwnershipAsync(AppServiceDomain domain) {
        return domain.verifyDomainOwnershipAsync(this.name(), this.domainVerificationToken());
    }

    @Override
    public String distinguishedName() {
        return ((AppServiceCertificateOrderInner)((Object)this.innerModel())).distinguishedName();
    }

    @Override
    public String domainVerificationToken() {
        return ((AppServiceCertificateOrderInner)((Object)this.innerModel())).domainVerificationToken();
    }

    @Override
    public int validityInYears() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((AppServiceCertificateOrderInner)((Object)this.innerModel())).validityInYears());
    }

    @Override
    public int keySize() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((AppServiceCertificateOrderInner)((Object)this.innerModel())).keySize());
    }

    @Override
    public CertificateProductType productType() {
        return ((AppServiceCertificateOrderInner)((Object)this.innerModel())).productType();
    }

    @Override
    public boolean autoRenew() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((AppServiceCertificateOrderInner)((Object)this.innerModel())).autoRenew());
    }

    @Override
    public CertificateOrderStatus status() {
        return ((AppServiceCertificateOrderInner)((Object)this.innerModel())).status();
    }

    @Override
    public CertificateDetails signedCertificate() {
        return ((AppServiceCertificateOrderInner)((Object)this.innerModel())).signedCertificate();
    }

    @Override
    public String certificateSigningRequest() {
        return ((AppServiceCertificateOrderInner)((Object)this.innerModel())).csr();
    }

    @Override
    public CertificateDetails intermediate() {
        return ((AppServiceCertificateOrderInner)((Object)this.innerModel())).intermediate();
    }

    @Override
    public CertificateDetails root() {
        return ((AppServiceCertificateOrderInner)((Object)this.innerModel())).root();
    }

    @Override
    public String serialNumber() {
        return ((AppServiceCertificateOrderInner)((Object)this.innerModel())).serialNumber();
    }

    @Override
    public OffsetDateTime lastCertificateIssuanceTime() {
        return ((AppServiceCertificateOrderInner)((Object)this.innerModel())).lastCertificateIssuanceTime();
    }

    @Override
    public OffsetDateTime expirationTime() {
        return ((AppServiceCertificateOrderInner)((Object)this.innerModel())).expirationTime();
    }

    @Override
    public AppServiceCertificateKeyVaultBinding createKeyVaultBinding(String certificateName, Vault vault) {
        return (AppServiceCertificateKeyVaultBinding)this.createKeyVaultBindingAsync(certificateName, vault).block();
    }

    @Override
    public Mono<AppServiceCertificateKeyVaultBinding> createKeyVaultBindingAsync(String certificateName, Vault vault) {
        AppServiceCertificateResourceInner certInner = new AppServiceCertificateResourceInner();
        certInner.withLocation(vault.regionName());
        certInner.withKeyVaultId(vault.id());
        certInner.withKeyVaultSecretName(certificateName);
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServiceCertificateOrders().createOrUpdateCertificateAsync(this.resourceGroupName(), this.name(), certificateName, certInner).map(appServiceCertificateInner -> new AppServiceCertificateKeyVaultBindingImpl((AppServiceCertificateResourceInner)((Object)appServiceCertificateInner), this));
    }

    @Override
    public AppServiceCertificateOrderImpl withHostName(String hostName) {
        ((AppServiceCertificateOrderInner)((Object)this.innerModel())).withDistinguishedName("CN=" + hostName);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withStandardSku() {
        ((AppServiceCertificateOrderInner)((Object)this.innerModel())).withProductType(CertificateProductType.STANDARD_DOMAIN_VALIDATED_SSL);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withWildcardSku() {
        ((AppServiceCertificateOrderInner)((Object)this.innerModel())).withProductType(CertificateProductType.STANDARD_DOMAIN_VALIDATED_WILD_CARD_SSL);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withValidYears(int years) {
        ((AppServiceCertificateOrderInner)((Object)this.innerModel())).withValidityInYears(years);
        return this;
    }

    public Mono<AppServiceCertificateOrder> createResourceAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServiceCertificateOrders().createOrUpdateAsync(this.resourceGroupName(), this.name(), (AppServiceCertificateOrderInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).then(Mono.defer(() -> {
            if (this.domainVerifyWebApp != null) {
                return this.domainVerifyWebApp.verifyDomainOwnershipAsync(this.name(), this.domainVerificationToken());
            }
            if (this.domainVerifyDomain != null) {
                return this.domainVerifyDomain.verifyDomainOwnershipAsync(this.name(), this.domainVerificationToken());
            }
            return Mono.error((Throwable)new IllegalArgumentException("Please specify a non-null web app or domain to verify the domain ownership for hostname " + this.distinguishedName()));
        })).then(this.bindingVault.flatMap(vault -> this.createKeyVaultBindingAsync(this.name(), (Vault)vault))).then(Mono.just((Object)this));
    }

    @Override
    public AppServiceCertificateOrderImpl withAutoRenew(boolean enabled) {
        ((AppServiceCertificateOrderInner)((Object)this.innerModel())).withAutoRenew(enabled);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withDomainVerification(AppServiceDomain domain) {
        this.domainVerifyDomain = domain;
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withWebAppVerification(WebAppBase webApp) {
        this.domainVerifyWebApp = webApp;
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withExistingKeyVault(Vault vault) {
        this.bindingVault = Mono.just((Object)vault);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withNewKeyVault(String vaultName, Region region) {
        this.bindingVault = ((Vault.DefinitionStages.WithCreate)((Vault.DefinitionStages.WithCreate)((Vault.DefinitionStages.WithAccessPolicy)((Vault.DefinitionStages.WithGroup)((Vault.DefinitionStages.Blank)((AppServiceManager)this.myManager).keyVaultManager().vaults().define(vaultName)).withRegion(region)).withExistingResourceGroup(this.resourceGroupName())).defineAccessPolicy().forServicePrincipal("f3c21649-0979-4721-ac85-b0216b2cf413").allowSecretPermissions(new SecretPermissions[]{SecretPermissions.GET, SecretPermissions.SET, SecretPermissions.DELETE}).attach()).defineAccessPolicy().forServicePrincipal("abfa0a7c-a6b6-4736-8310-5855508787cd").allowSecretPermissions(new SecretPermissions[]{SecretPermissions.GET}).attach()).createAsync();
        return this;
    }
}

