/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.RbacV1alpha1Subject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1alpha1RoleRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="RoleBinding references a role, but does not contain it.  It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 RoleBinding, and will no longer be served in v1.22.")
public class V1alpha1RoleBinding
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_ROLE_REF = "roleRef";
    @SerializedName(value="roleRef")
    private V1alpha1RoleRef roleRef;
    public static final String SERIALIZED_NAME_SUBJECTS = "subjects";
    @SerializedName(value="subjects")
    private List<RbacV1alpha1Subject> subjects = null;

    public V1alpha1RoleBinding apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha1RoleBinding kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha1RoleBinding metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha1RoleBinding roleRef(V1alpha1RoleRef roleRef) {
        this.roleRef = roleRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1alpha1RoleRef getRoleRef() {
        return this.roleRef;
    }

    public void setRoleRef(V1alpha1RoleRef roleRef) {
        this.roleRef = roleRef;
    }

    public V1alpha1RoleBinding subjects(List<RbacV1alpha1Subject> subjects) {
        this.subjects = subjects;
        return this;
    }

    public V1alpha1RoleBinding addSubjectsItem(RbacV1alpha1Subject subjectsItem) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<RbacV1alpha1Subject>();
        }
        this.subjects.add(subjectsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subjects holds references to the objects the role applies to.")
    public List<RbacV1alpha1Subject> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<RbacV1alpha1Subject> subjects) {
        this.subjects = subjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1RoleBinding v1alpha1RoleBinding = (V1alpha1RoleBinding)o;
        return Objects.equals(this.apiVersion, v1alpha1RoleBinding.apiVersion) && Objects.equals(this.kind, v1alpha1RoleBinding.kind) && Objects.equals(this.metadata, v1alpha1RoleBinding.metadata) && Objects.equals(this.roleRef, v1alpha1RoleBinding.roleRef) && Objects.equals(this.subjects, v1alpha1RoleBinding.subjects);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.roleRef, this.subjects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1RoleBinding {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    roleRef: ").append(this.toIndentedString(this.roleRef)).append("\n");
        sb.append("    subjects: ").append(this.toIndentedString(this.subjects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

