/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.Response;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.azure.resourcemanager.compute.implementation.EncryptionExtensionIdentifier;
import com.azure.resourcemanager.compute.implementation.LinuxEncryptionExtensionUtil;
import com.azure.resourcemanager.compute.models.DiskVolumeEncryptionMonitor;
import com.azure.resourcemanager.compute.models.EncryptionStatus;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

class LinuxDiskVolumeLegacyEncryptionMonitorImpl
implements DiskVolumeEncryptionMonitor {
    private final String rgName;
    private final String vmName;
    private final ComputeManager computeManager;
    private VirtualMachineExtensionInner encryptionExtension;

    LinuxDiskVolumeLegacyEncryptionMonitorImpl(String virtualMachineId, ComputeManager computeManager) {
        this.rgName = ResourceUtils.groupFromResourceId((String)virtualMachineId);
        this.vmName = ResourceUtils.nameFromResourceId((String)virtualMachineId);
        this.computeManager = computeManager;
    }

    @Override
    public OperatingSystemTypes osType() {
        return OperatingSystemTypes.LINUX;
    }

    @Override
    public String progressMessage() {
        if (!this.hasEncryptionExtension()) {
            return null;
        }
        return LinuxEncryptionExtensionUtil.progressMessage(this.encryptionExtension.instanceView());
    }

    @Override
    public EncryptionStatus osDiskStatus() {
        if (!this.hasEncryptionExtension()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return LinuxEncryptionExtensionUtil.osDiskStatus(this.encryptionExtension.instanceView());
    }

    @Override
    public EncryptionStatus dataDiskStatus() {
        if (!this.hasEncryptionExtension()) {
            return EncryptionStatus.NOT_ENCRYPTED;
        }
        return LinuxEncryptionExtensionUtil.dataDiskStatus(this.encryptionExtension.instanceView());
    }

    @Override
    public Map<String, InstanceViewStatus> diskInstanceViewEncryptionStatuses() {
        return new HashMap<String, InstanceViewStatus>();
    }

    public DiskVolumeEncryptionMonitor refresh() {
        return (DiskVolumeEncryptionMonitor)this.refreshAsync().block();
    }

    @Override
    public Mono<DiskVolumeEncryptionMonitor> refreshAsync() {
        LinuxDiskVolumeLegacyEncryptionMonitorImpl self = this;
        return this.retrieveEncryptExtensionWithInstanceViewAsync().flatMap(virtualMachineExtensionInner -> {
            this.encryptionExtension = virtualMachineExtensionInner;
            return Mono.just((Object)self);
        }).switchIfEmpty(Mono.just((Object)self));
    }

    private Mono<VirtualMachineExtensionInner> retrieveEncryptExtensionWithInstanceViewAsync() {
        if (this.encryptionExtension != null) {
            return this.retrieveExtensionWithInstanceViewAsync(this.encryptionExtension);
        }
        return this.retrieveEncryptExtensionWithInstanceViewFromVMAsync();
    }

    private Mono<VirtualMachineExtensionInner> retrieveExtensionWithInstanceViewAsync(VirtualMachineExtensionInner extension) {
        return ((ComputeManagementClient)this.computeManager.serviceClient()).getVirtualMachineExtensions().getWithResponseAsync(this.rgName, this.vmName, extension.name(), "instanceView").map(Response::getValue);
    }

    private Mono<VirtualMachineExtensionInner> retrieveEncryptExtensionWithInstanceViewFromVMAsync() {
        return ((ComputeManagementClient)this.computeManager.serviceClient()).getVirtualMachines().getByResourceGroupAsync(this.rgName, this.vmName).flatMap(virtualMachine -> {
            if (virtualMachine.resources() != null) {
                for (VirtualMachineExtensionInner extension : virtualMachine.resources()) {
                    if (!EncryptionExtensionIdentifier.isEncryptionPublisherName(extension.publisher()) || !EncryptionExtensionIdentifier.isEncryptionTypeName(extension.typePropertiesType(), OperatingSystemTypes.LINUX)) continue;
                    return this.retrieveExtensionWithInstanceViewAsync(extension);
                }
            }
            return Mono.empty();
        });
    }

    private boolean hasEncryptionExtension() {
        return this.encryptionExtension != null;
    }
}

