/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.config;

import java.time.Duration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.server.worker.config.PhysicalTaskConfig;
import org.apache.dolphinscheduler.server.worker.config.TenantConfig;
import org.apache.dolphinscheduler.server.worker.config.WorkerServerLoadProtectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties(prefix="worker")
public class WorkerConfig
implements Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerConfig.class);
    private int listenPort = 1234;
    private Duration maxHeartbeatInterval = Duration.ofSeconds(10L);
    private int hostWeight = 100;
    private WorkerServerLoadProtectionConfig serverLoadProtection = new WorkerServerLoadProtectionConfig();
    private String group;
    private String workerAddress;
    private String workerRegistryPath;
    private TenantConfig tenantConfig = new TenantConfig();
    private PhysicalTaskConfig physicalTaskConfig = new PhysicalTaskConfig();

    public boolean supports(Class<?> clazz) {
        return WorkerConfig.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        WorkerConfig workerConfig = (WorkerConfig)target;
        if (workerConfig.getMaxHeartbeatInterval().getSeconds() <= 0L) {
            errors.rejectValue("max-heartbeat-interval", null, "should be a valid duration");
        }
        if (StringUtils.isEmpty((CharSequence)workerConfig.getWorkerAddress())) {
            workerConfig.setWorkerAddress(NetUtils.getAddr((int)workerConfig.getListenPort()));
        }
        workerConfig.setWorkerRegistryPath(RegistryNodeType.WORKER.getRegistryPath() + "/" + workerConfig.getWorkerAddress());
        if (StringUtils.isEmpty((CharSequence)this.group)) {
            workerConfig.setGroup("default");
        }
        this.printConfig();
    }

    private void printConfig() {
        String config = "\n****************************Worker Configuration**************************************\n  listen-port -> " + this.listenPort + "\n  max-heartbeat-interval -> " + this.maxHeartbeatInterval + "\n  host-weight -> " + this.hostWeight + "\n  tenantConfig -> " + this.tenantConfig + "\n  server-load-protection -> " + (Object)((Object)this.serverLoadProtection) + "\n  address -> " + this.workerAddress + "\n  registry-path: " + this.workerRegistryPath + "\n  physical-task-config -> " + this.physicalTaskConfig + "\n  group -> " + this.group + "\n****************************Worker Configuration**************************************";
        log.info(config);
    }

    @Generated
    public WorkerConfig() {
    }

    @Generated
    public int getListenPort() {
        return this.listenPort;
    }

    @Generated
    public Duration getMaxHeartbeatInterval() {
        return this.maxHeartbeatInterval;
    }

    @Generated
    public int getHostWeight() {
        return this.hostWeight;
    }

    @Generated
    public WorkerServerLoadProtectionConfig getServerLoadProtection() {
        return this.serverLoadProtection;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public String getWorkerAddress() {
        return this.workerAddress;
    }

    @Generated
    public String getWorkerRegistryPath() {
        return this.workerRegistryPath;
    }

    @Generated
    public TenantConfig getTenantConfig() {
        return this.tenantConfig;
    }

    @Generated
    public PhysicalTaskConfig getPhysicalTaskConfig() {
        return this.physicalTaskConfig;
    }

    @Generated
    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    @Generated
    public void setMaxHeartbeatInterval(Duration maxHeartbeatInterval) {
        this.maxHeartbeatInterval = maxHeartbeatInterval;
    }

    @Generated
    public void setHostWeight(int hostWeight) {
        this.hostWeight = hostWeight;
    }

    @Generated
    public void setServerLoadProtection(WorkerServerLoadProtectionConfig serverLoadProtection) {
        this.serverLoadProtection = serverLoadProtection;
    }

    @Generated
    public void setGroup(String group) {
        this.group = group;
    }

    @Generated
    public void setWorkerAddress(String workerAddress) {
        this.workerAddress = workerAddress;
    }

    @Generated
    public void setWorkerRegistryPath(String workerRegistryPath) {
        this.workerRegistryPath = workerRegistryPath;
    }

    @Generated
    public void setTenantConfig(TenantConfig tenantConfig) {
        this.tenantConfig = tenantConfig;
    }

    @Generated
    public void setPhysicalTaskConfig(PhysicalTaskConfig physicalTaskConfig) {
        this.physicalTaskConfig = physicalTaskConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerConfig)) {
            return false;
        }
        WorkerConfig other = (WorkerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getListenPort() != other.getListenPort()) {
            return false;
        }
        if (this.getHostWeight() != other.getHostWeight()) {
            return false;
        }
        Duration this$maxHeartbeatInterval = this.getMaxHeartbeatInterval();
        Duration other$maxHeartbeatInterval = other.getMaxHeartbeatInterval();
        if (this$maxHeartbeatInterval == null ? other$maxHeartbeatInterval != null : !((Object)this$maxHeartbeatInterval).equals(other$maxHeartbeatInterval)) {
            return false;
        }
        WorkerServerLoadProtectionConfig this$serverLoadProtection = this.getServerLoadProtection();
        WorkerServerLoadProtectionConfig other$serverLoadProtection = other.getServerLoadProtection();
        if (this$serverLoadProtection == null ? other$serverLoadProtection != null : !((Object)((Object)this$serverLoadProtection)).equals((Object)other$serverLoadProtection)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$workerAddress = this.getWorkerAddress();
        String other$workerAddress = other.getWorkerAddress();
        if (this$workerAddress == null ? other$workerAddress != null : !this$workerAddress.equals(other$workerAddress)) {
            return false;
        }
        String this$workerRegistryPath = this.getWorkerRegistryPath();
        String other$workerRegistryPath = other.getWorkerRegistryPath();
        if (this$workerRegistryPath == null ? other$workerRegistryPath != null : !this$workerRegistryPath.equals(other$workerRegistryPath)) {
            return false;
        }
        TenantConfig this$tenantConfig = this.getTenantConfig();
        TenantConfig other$tenantConfig = other.getTenantConfig();
        if (this$tenantConfig == null ? other$tenantConfig != null : !((Object)this$tenantConfig).equals(other$tenantConfig)) {
            return false;
        }
        PhysicalTaskConfig this$physicalTaskConfig = this.getPhysicalTaskConfig();
        PhysicalTaskConfig other$physicalTaskConfig = other.getPhysicalTaskConfig();
        return !(this$physicalTaskConfig == null ? other$physicalTaskConfig != null : !((Object)this$physicalTaskConfig).equals(other$physicalTaskConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkerConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getListenPort();
        result = result * 59 + this.getHostWeight();
        Duration $maxHeartbeatInterval = this.getMaxHeartbeatInterval();
        result = result * 59 + ($maxHeartbeatInterval == null ? 43 : ((Object)$maxHeartbeatInterval).hashCode());
        WorkerServerLoadProtectionConfig $serverLoadProtection = this.getServerLoadProtection();
        result = result * 59 + ($serverLoadProtection == null ? 43 : ((Object)((Object)$serverLoadProtection)).hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $workerAddress = this.getWorkerAddress();
        result = result * 59 + ($workerAddress == null ? 43 : $workerAddress.hashCode());
        String $workerRegistryPath = this.getWorkerRegistryPath();
        result = result * 59 + ($workerRegistryPath == null ? 43 : $workerRegistryPath.hashCode());
        TenantConfig $tenantConfig = this.getTenantConfig();
        result = result * 59 + ($tenantConfig == null ? 43 : ((Object)$tenantConfig).hashCode());
        PhysicalTaskConfig $physicalTaskConfig = this.getPhysicalTaskConfig();
        result = result * 59 + ($physicalTaskConfig == null ? 43 : ((Object)$physicalTaskConfig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkerConfig(listenPort=" + this.getListenPort() + ", maxHeartbeatInterval=" + this.getMaxHeartbeatInterval() + ", hostWeight=" + this.getHostWeight() + ", serverLoadProtection=" + (Object)((Object)this.getServerLoadProtection()) + ", group=" + this.getGroup() + ", workerAddress=" + this.getWorkerAddress() + ", workerRegistryPath=" + this.getWorkerRegistryPath() + ", tenantConfig=" + this.getTenantConfig() + ", physicalTaskConfig=" + this.getPhysicalTaskConfig() + ")";
    }
}

