/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.util.ModelMapper;
import io.kubernetes.client.util.Strings;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import io.kubernetes.client.util.generic.options.CreateOptions;

public class KubectlCreate<ApiType extends KubernetesObject>
extends Kubectl.ResourceBuilder<ApiType, KubectlCreate<ApiType>>
implements Kubectl.Executable<ApiType> {
    private ApiType targetObj;

    KubectlCreate(Class<ApiType> apiTypeClass) {
        super(apiTypeClass);
    }

    public KubectlCreate<ApiType> resource(ApiType obj) {
        this.targetObj = obj;
        return this;
    }

    @Override
    public ApiType execute() throws KubectlException {
        this.refreshDiscovery();
        GenericKubernetesApi api = this.getGenericApi();
        if (ModelMapper.isNamespaced(this.targetObj.getClass()).booleanValue()) {
            String targetNamespace = this.namespace != null ? this.namespace : (Strings.isNullOrEmpty((String)this.targetObj.getMetadata().getNamespace()) ? "default" : this.targetObj.getMetadata().getNamespace());
            try {
                return (ApiType)((KubernetesObject)api.create(targetNamespace, this.targetObj, new CreateOptions()).throwsApiException().getObject());
            }
            catch (ApiException e) {
                throw new KubectlException(e);
            }
        }
        try {
            return (ApiType)((KubernetesObject)api.create(this.targetObj, new CreateOptions()).throwsApiException().getObject());
        }
        catch (ApiException e) {
            throw new KubectlException(e);
        }
    }
}

