/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.model;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.SerialCommand;

public class SerialCommandDto {
    private Integer id;
    private Integer workflowInstanceId;
    private Long workflowDefinitionCode;
    private Integer workflowDefinitionVersion;
    private Command command;
    private State state;
    private Date createTime;
    private Date updateTime;

    public static SerialCommandDto newSerialCommand(Command command) {
        return SerialCommandDto.builder().workflowInstanceId(command.getWorkflowInstanceId()).command(command).workflowDefinitionCode(command.getWorkflowDefinitionCode()).workflowDefinitionVersion(command.getWorkflowDefinitionVersion()).state(State.WAITING).createTime(new Date()).updateTime(new Date()).build();
    }

    public static SerialCommandDto fromEntity(SerialCommand serialCommand) {
        return SerialCommandDto.builder().id(serialCommand.getId()).workflowInstanceId(serialCommand.getWorkflowInstanceId()).workflowDefinitionCode(serialCommand.getWorkflowDefinitionCode()).workflowDefinitionVersion(serialCommand.getWorkflowDefinitionVersion()).command((Command)JSONUtils.parseObject((String)serialCommand.getCommand(), (TypeReference)new TypeReference<Command>(){})).state(State.of(serialCommand.getState())).createTime(serialCommand.getCreateTime()).updateTime(serialCommand.getUpdateTime()).build();
    }

    public SerialCommand toEntity() {
        return SerialCommand.builder().id(this.id).workflowInstanceId(this.workflowInstanceId).workflowDefinitionCode(this.workflowDefinitionCode).workflowDefinitionVersion(this.workflowDefinitionVersion).command(JSONUtils.toJsonString((Object)this.command)).state(this.state.getValue()).createTime(this.createTime).updateTime(this.updateTime).build();
    }

    @Generated
    public static SerialCommandDtoBuilder builder() {
        return new SerialCommandDtoBuilder();
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public Integer getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    @Generated
    public Long getWorkflowDefinitionCode() {
        return this.workflowDefinitionCode;
    }

    @Generated
    public Integer getWorkflowDefinitionVersion() {
        return this.workflowDefinitionVersion;
    }

    @Generated
    public Command getCommand() {
        return this.command;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public Date getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setWorkflowInstanceId(Integer workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    @Generated
    public void setWorkflowDefinitionCode(Long workflowDefinitionCode) {
        this.workflowDefinitionCode = workflowDefinitionCode;
    }

    @Generated
    public void setWorkflowDefinitionVersion(Integer workflowDefinitionVersion) {
        this.workflowDefinitionVersion = workflowDefinitionVersion;
    }

    @Generated
    public void setCommand(Command command) {
        this.command = command;
    }

    @Generated
    public void setState(State state) {
        this.state = state;
    }

    @Generated
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerialCommandDto)) {
            return false;
        }
        SerialCommandDto other = (SerialCommandDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$workflowInstanceId = this.getWorkflowInstanceId();
        Integer other$workflowInstanceId = other.getWorkflowInstanceId();
        if (this$workflowInstanceId == null ? other$workflowInstanceId != null : !((Object)this$workflowInstanceId).equals(other$workflowInstanceId)) {
            return false;
        }
        Long this$workflowDefinitionCode = this.getWorkflowDefinitionCode();
        Long other$workflowDefinitionCode = other.getWorkflowDefinitionCode();
        if (this$workflowDefinitionCode == null ? other$workflowDefinitionCode != null : !((Object)this$workflowDefinitionCode).equals(other$workflowDefinitionCode)) {
            return false;
        }
        Integer this$workflowDefinitionVersion = this.getWorkflowDefinitionVersion();
        Integer other$workflowDefinitionVersion = other.getWorkflowDefinitionVersion();
        if (this$workflowDefinitionVersion == null ? other$workflowDefinitionVersion != null : !((Object)this$workflowDefinitionVersion).equals(other$workflowDefinitionVersion)) {
            return false;
        }
        Command this$command = this.getCommand();
        Command other$command = other.getCommand();
        if (this$command == null ? other$command != null : !((Object)this$command).equals(other$command)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SerialCommandDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $workflowInstanceId = this.getWorkflowInstanceId();
        result = result * 59 + ($workflowInstanceId == null ? 43 : ((Object)$workflowInstanceId).hashCode());
        Long $workflowDefinitionCode = this.getWorkflowDefinitionCode();
        result = result * 59 + ($workflowDefinitionCode == null ? 43 : ((Object)$workflowDefinitionCode).hashCode());
        Integer $workflowDefinitionVersion = this.getWorkflowDefinitionVersion();
        result = result * 59 + ($workflowDefinitionVersion == null ? 43 : ((Object)$workflowDefinitionVersion).hashCode());
        Command $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : ((Object)$command).hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SerialCommandDto(id=" + this.getId() + ", workflowInstanceId=" + this.getWorkflowInstanceId() + ", workflowDefinitionCode=" + this.getWorkflowDefinitionCode() + ", workflowDefinitionVersion=" + this.getWorkflowDefinitionVersion() + ", command=" + this.getCommand() + ", state=" + (Object)((Object)this.getState()) + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }

    @Generated
    public SerialCommandDto(Integer id, Integer workflowInstanceId, Long workflowDefinitionCode, Integer workflowDefinitionVersion, Command command, State state, Date createTime, Date updateTime) {
        this.id = id;
        this.workflowInstanceId = workflowInstanceId;
        this.workflowDefinitionCode = workflowDefinitionCode;
        this.workflowDefinitionVersion = workflowDefinitionVersion;
        this.command = command;
        this.state = state;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }

    @Generated
    public SerialCommandDto() {
    }

    @Generated
    public static class SerialCommandDtoBuilder {
        @Generated
        private Integer id;
        @Generated
        private Integer workflowInstanceId;
        @Generated
        private Long workflowDefinitionCode;
        @Generated
        private Integer workflowDefinitionVersion;
        @Generated
        private Command command;
        @Generated
        private State state;
        @Generated
        private Date createTime;
        @Generated
        private Date updateTime;

        @Generated
        SerialCommandDtoBuilder() {
        }

        @Generated
        public SerialCommandDtoBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        @Generated
        public SerialCommandDtoBuilder workflowInstanceId(Integer workflowInstanceId) {
            this.workflowInstanceId = workflowInstanceId;
            return this;
        }

        @Generated
        public SerialCommandDtoBuilder workflowDefinitionCode(Long workflowDefinitionCode) {
            this.workflowDefinitionCode = workflowDefinitionCode;
            return this;
        }

        @Generated
        public SerialCommandDtoBuilder workflowDefinitionVersion(Integer workflowDefinitionVersion) {
            this.workflowDefinitionVersion = workflowDefinitionVersion;
            return this;
        }

        @Generated
        public SerialCommandDtoBuilder command(Command command) {
            this.command = command;
            return this;
        }

        @Generated
        public SerialCommandDtoBuilder state(State state) {
            this.state = state;
            return this;
        }

        @Generated
        public SerialCommandDtoBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        @Generated
        public SerialCommandDtoBuilder updateTime(Date updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Generated
        public SerialCommandDto build() {
            return new SerialCommandDto(this.id, this.workflowInstanceId, this.workflowDefinitionCode, this.workflowDefinitionVersion, this.command, this.state, this.createTime, this.updateTime);
        }

        @Generated
        public String toString() {
            return "SerialCommandDto.SerialCommandDtoBuilder(id=" + this.id + ", workflowInstanceId=" + this.workflowInstanceId + ", workflowDefinitionCode=" + this.workflowDefinitionCode + ", workflowDefinitionVersion=" + this.workflowDefinitionVersion + ", command=" + this.command + ", state=" + (Object)((Object)this.state) + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ")";
        }
    }

    public static enum State {
        WAITING(0),
        LAUNCHED(1);

        private final int value;

        private State(int value) {
            this.value = value;
        }

        public static State of(int value) {
            for (State state : State.values()) {
                if (state.value != value) continue;
                return state;
            }
            throw new IllegalArgumentException("Invalid State value: " + value);
        }

        @Generated
        public int getValue() {
            return this.value;
        }
    }
}

