/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.statemachine;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.SerialCommandDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.engine.AbstractLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.WorkflowCacheRepository;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBus;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBusCoordinator;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.graph.SuccessorFlowAdjuster;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskStartLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowFinalizeLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.statemachine.IWorkflowStateAction;
import org.apache.dolphinscheduler.server.master.utils.WorkflowInstanceUtils;
import org.apache.dolphinscheduler.service.alert.WorkflowAlertManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractWorkflowStateAction
implements IWorkflowStateAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkflowStateAction.class);
    @Autowired
    protected SuccessorFlowAdjuster successorFlowAdjuster;
    @Autowired
    protected WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    protected WorkflowCacheRepository workflowCacheRepository;
    @Autowired
    protected WorkflowEventBusCoordinator workflowEventBusCoordinator;
    @Autowired
    protected WorkflowAlertManager workflowAlertManager;
    @Autowired
    protected TransactionTemplate transactionTemplate;
    @Autowired
    protected SerialCommandDao serialCommandDao;

    protected void triggerTasks(IWorkflowExecutionRunnable workflowExecutionRunnable, List<ITaskExecutionRunnable> triggerCandidateTasks) {
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecutionGraph();
        List readyToTriggerTasks = triggerCandidateTasks.stream().filter(workflowExecutionGraph::isTriggerConditionMet).sorted(Comparator.comparing(ITaskExecutionRunnable::getName)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(readyToTriggerTasks)) {
            return;
        }
        WorkflowEventBus workflowEventBus = workflowExecutionRunnable.getWorkflowEventBus();
        for (ITaskExecutionRunnable readyToTriggerTask : readyToTriggerTasks) {
            workflowExecutionGraph.markTaskExecutionRunnableActive(readyToTriggerTask);
            if (workflowExecutionGraph.isTaskExecutionRunnableSkipped(readyToTriggerTask) || workflowExecutionGraph.isTaskExecutionRunnableForbidden(readyToTriggerTask)) {
                workflowEventBus.publish(WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent.of(workflowExecutionRunnable, readyToTriggerTask));
                continue;
            }
            workflowEventBus.publish(TaskStartLifecycleEvent.of(readyToTriggerTask));
        }
    }

    protected void killActiveTask(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        try {
            LogUtils.setWorkflowInstanceIdMDC((Integer)workflowExecutionRunnable.getId());
            workflowExecutionRunnable.getWorkflowExecutionGraph().getActiveTaskExecutionRunnable().forEach(ITaskExecutionRunnable::kill);
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    protected void pauseActiveTask(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        try {
            LogUtils.setWorkflowInstanceIdMDC((Integer)workflowExecutionRunnable.getId());
            workflowExecutionRunnable.getWorkflowExecutionGraph().getActiveTaskExecutionRunnable().forEach(ITaskExecutionRunnable::pause);
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    protected void tryToTriggerSuccessorsAfterTaskFinish(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable) {
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecutionGraph();
        if (workflowExecutionGraph.isEndOfTaskChain(taskExecutionRunnable)) {
            this.emitWorkflowFinishedEventIfApplicable(workflowExecutionRunnable);
            return;
        }
        this.successorFlowAdjuster.adjustSuccessorFlow(taskExecutionRunnable);
        List<ITaskExecutionRunnable> successors = workflowExecutionGraph.getSuccessors(taskExecutionRunnable);
        if (successors.isEmpty()) {
            log.debug("The task: {} has no successor, try to emit workflow finished event", (Object)taskExecutionRunnable.getName());
            this.emitWorkflowFinishedEventIfApplicable(workflowExecutionRunnable);
            return;
        }
        this.triggerTasks(workflowExecutionRunnable, successors);
    }

    protected void workflowFinish(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowExecutionStatus workflowExecutionStatus) {
        this.transactionTemplate.execute(status -> {
            WorkflowInstance workflowInstance = workflowExecutionRunnable.getWorkflowInstance();
            workflowInstance.setEndTime(new Date());
            this.transformWorkflowInstanceState(workflowExecutionRunnable, workflowExecutionStatus);
            if (workflowExecutionRunnable.getWorkflowExecuteContext().getWorkflowDefinition().getExecutionType().isSerial() && this.serialCommandDao.deleteByWorkflowInstanceId(workflowInstance.getId()) > 0) {
                log.info("Success clear SerialCommand for WorkflowExecuteRunnable: {}", (Object)workflowExecutionRunnable.getName());
            }
            workflowExecutionRunnable.getWorkflowEventBus().publish(WorkflowFinalizeLifecycleEvent.of(workflowExecutionRunnable));
            return null;
        });
    }

    protected void transformWorkflowInstanceState(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowExecutionStatus targetState) {
        WorkflowInstance workflowInstance = workflowExecutionRunnable.getWorkflowInstance();
        WorkflowExecutionStatus originState = workflowInstance.getState();
        try {
            workflowInstance.setState(targetState);
            this.workflowInstanceDao.updateById((Object)workflowInstance);
            log.info("Success set WorkflowExecuteRunnable: {} state from: {} to {}", new Object[]{workflowInstance.getName(), originState.name(), targetState.name()});
        }
        catch (Exception ex) {
            workflowInstance.setState(originState);
            throw ex;
        }
    }

    protected abstract void emitWorkflowFinishedEventIfApplicable(IWorkflowExecutionRunnable var1);

    protected boolean isWorkflowFinishable(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        return workflowExecutionRunnable.getWorkflowExecutionGraph().isAllTaskExecutionRunnableChainFinish();
    }

    protected void throwExceptionIfStateIsNotMatch(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        Preconditions.checkNotNull((Object)workflowExecutionRunnable, (Object)"workflowExecutionRunnable is null");
        WorkflowExecutionStatus actualState = workflowExecutionRunnable.getState();
        WorkflowExecutionStatus expectState = this.matchState();
        if (actualState != expectState) {
            String workflowName = workflowExecutionRunnable.getName();
            throw new IllegalStateException("The workflow: " + workflowName + " state: " + actualState + " is not match:" + expectState);
        }
    }

    protected void logWarningIfCannotDoAction(IWorkflowExecutionRunnable workflowExecutionRunnable, AbstractLifecycleEvent event) {
        log.warn("Workflow {} state is {} cannot do action on event: {}", new Object[]{workflowExecutionRunnable.getName(), workflowExecutionRunnable.getState(), event});
    }

    protected void finalizeEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        log.info(WorkflowInstanceUtils.logWorkflowInstanceInDetails(workflowExecutionRunnable));
        this.workflowCacheRepository.remove(workflowExecutionRunnable.getId());
        this.workflowEventBusCoordinator.unRegisterWorkflowEventBus(workflowExecutionRunnable);
        this.workflowAlertManager.sendAlertWorkflowInstance(workflowExecutionRunnable.getWorkflowInstance());
        log.info("Successfully finalize WorkflowExecuteRunnable: {}", (Object)workflowExecutionRunnable.getName());
    }
}

