/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dns.DnsZoneManager;
import com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.dns.implementation.ARecordSetImpl;
import com.azure.resourcemanager.dns.implementation.DnsRecordSetsBaseImpl;
import com.azure.resourcemanager.dns.implementation.DnsZoneImpl;
import com.azure.resourcemanager.dns.models.ARecordSet;
import com.azure.resourcemanager.dns.models.ARecordSets;
import com.azure.resourcemanager.dns.models.RecordType;
import reactor.core.publisher.Mono;

class ARecordSetsImpl
extends DnsRecordSetsBaseImpl<ARecordSet, ARecordSetImpl>
implements ARecordSets {
    ARecordSetsImpl(DnsZoneImpl dnsZone) {
        super(dnsZone, RecordType.A);
    }

    public ARecordSet getByName(String name) {
        return (ARecordSet)this.getByNameAsync(name).block();
    }

    public Mono<ARecordSet> getByNameAsync(String name) {
        return ((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().getAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), name, this.recordType).map(this::wrapModel);
    }

    @Override
    protected PagedIterable<ARecordSet> listIntern(String recordSetNameSuffix, Integer pageSize) {
        return super.wrapList(((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByType(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType, pageSize, recordSetNameSuffix, Context.NONE));
    }

    @Override
    protected PagedFlux<ARecordSet> listInternAsync(String recordSetNameSuffix, Integer pageSize) {
        return this.wrapPageAsync(((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByTypeAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType));
    }

    protected ARecordSetImpl wrapModel(RecordSetInner inner) {
        return new ARecordSetImpl(inner.name(), this.dnsZone, inner);
    }
}

