/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.CustomSessionCredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.auth.EnvironmentVariableCredentialsProvider;
import com.aliyun.oss.common.auth.InstanceProfileCredentialsProvider;
import com.aliyun.oss.common.auth.STSAssumeRoleSessionCredentialsProvider;
import com.aliyun.oss.common.auth.STSKeyPairSessionCredentialsProvider;
import com.aliyun.oss.common.auth.SystemPropertiesCredentialsProvider;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.BasicCredentials;
import com.aliyuncs.auth.KeyPairCredentials;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;

public class CredentialsProviderFactory {
    public static DefaultCredentialProvider newDefaultCredentialProvider(String accessKeyId, String secretAccessKey) {
        return new DefaultCredentialProvider(accessKeyId, secretAccessKey);
    }

    public DefaultCredentialProvider newDefaultCredentialProvider(String accessKeyId, String secretAccessKey, String securityToken) {
        return new DefaultCredentialProvider(accessKeyId, secretAccessKey, securityToken);
    }

    public static EnvironmentVariableCredentialsProvider newEnvironmentVariableCredentialsProvider() throws ClientException {
        return new EnvironmentVariableCredentialsProvider();
    }

    public static SystemPropertiesCredentialsProvider newSystemPropertiesCredentialsProvider() throws ClientException {
        return new SystemPropertiesCredentialsProvider();
    }

    public static STSAssumeRoleSessionCredentialsProvider newSTSAssumeRoleSessionCredentialsProvider(String regionId, String accessKeyId, String accessKeySecret, String roleArn) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId);
        BasicCredentials basicCredentials = new BasicCredentials(accessKeyId, accessKeySecret);
        return new STSAssumeRoleSessionCredentialsProvider((AlibabaCloudCredentials)basicCredentials, roleArn, (IClientProfile)profile);
    }

    public static InstanceProfileCredentialsProvider newInstanceProfileCredentialsProvider(String roleName) throws ClientException {
        return new InstanceProfileCredentialsProvider(roleName);
    }

    public static STSKeyPairSessionCredentialsProvider newSTSKeyPairSessionCredentialsProvider(String regionId, String publicKeyId, String privateKey) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId);
        KeyPairCredentials keyPairCredentials = new KeyPairCredentials(publicKeyId, privateKey);
        return new STSKeyPairSessionCredentialsProvider(keyPairCredentials, (IClientProfile)profile);
    }

    public static CustomSessionCredentialsProvider newCustomSessionCredentialsProvider(String ossAuthServerHost) throws ClientException {
        return new CustomSessionCredentialsProvider(ossAuthServerHost);
    }
}

