/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.configuration.ApiConfig;
import org.apache.dolphinscheduler.api.configuration.OAuth2Configuration;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.security.Authenticator;
import org.apache.dolphinscheduler.api.security.impl.AbstractSsoAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.oidc.OidcAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.oidc.OidcConfigProperties;
import org.apache.dolphinscheduler.api.security.impl.oidc.OidcProviderConfig;
import org.apache.dolphinscheduler.api.service.SessionService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.model.OkHttpRequestHeaderContentType;
import org.apache.dolphinscheduler.common.model.OkHttpRequestHeaders;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OkHttpUtils;
import org.apache.dolphinscheduler.dao.entity.Session;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="LOGIN_TAG")
@RestController
@RequestMapping(value={""})
public class LoginController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    private final SessionService sessionService;
    private final Authenticator authenticator;
    private final OAuth2Configuration oAuth2Configuration;
    private final OidcConfigProperties oidcConfigProperties;
    private final UsersService usersService;
    private final ApiConfig apiConfig;

    @Autowired
    public LoginController(SessionService sessionService, Authenticator authenticator, UsersService usersService, Optional<OAuth2Configuration> oAuth2Configuration, Optional<OidcConfigProperties> oidcConfigProperties, ApiConfig apiConfig) {
        this.sessionService = sessionService;
        this.authenticator = authenticator;
        this.usersService = usersService;
        this.oAuth2Configuration = oAuth2Configuration.orElse(null);
        this.oidcConfigProperties = oidcConfigProperties.orElse(null);
        this.apiConfig = apiConfig;
    }

    @Operation(summary="login", description="LOGIN_NOTES")
    @Parameters(value={@Parameter(name="userName", description="USER_NAME", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="userPassword", description="USER_PASSWORD", required=true, schema=@Schema(implementation=String.class))})
    @PostMapping(value={"/login"})
    @ApiException(value=Status.USER_LOGIN_FAILURE)
    public Result login(@RequestParam(value="userName") String userName, @RequestParam(value="userPassword") String userPassword, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return this.error(Status.USER_NAME_NULL.getCode(), Status.USER_NAME_NULL.getMsg());
        }
        String ip = LoginController.getClientIpAddress(request);
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return this.error(Status.IP_IS_EMPTY.getCode(), Status.IP_IS_EMPTY.getMsg());
        }
        Result<Map<String, String>> result = this.authenticator.authenticate(userName, userPassword, ip);
        if (result.getCode().intValue() != Status.SUCCESS.getCode()) {
            return result;
        }
        response.setStatus(200);
        Map<String, String> cookieMap = result.getData();
        for (Map.Entry<String, String> cookieEntry : cookieMap.entrySet()) {
            Cookie cookie = new Cookie(cookieEntry.getKey(), cookieEntry.getValue());
            cookie.setHttpOnly(true);
            response.addCookie(cookie);
        }
        return result;
    }

    @Operation(summary="sso login", description="SSO_LOGIN_NOTES")
    @GetMapping(value={"/login/sso"})
    @ApiException(value=Status.NOT_SUPPORT_SSO)
    public Result ssoLogin(HttpServletRequest request) {
        if (this.authenticator instanceof OidcAuthenticator) {
            return Result.success(null);
        }
        if (this.authenticator instanceof AbstractSsoAuthenticator) {
            String randomState = UUID.randomUUID().toString();
            HttpSession session = request.getSession();
            if (session.getAttribute("sso.login.user.state") == null) {
                session.setAttribute("sso.login.user.state", (Object)randomState);
            }
            return Result.success(((AbstractSsoAuthenticator)this.authenticator).getSignInUrl(randomState));
        }
        return Result.success();
    }

    @Operation(summary="signOut", description="SIGN_OUT_NOTES")
    @PostMapping(value={"/signOut"})
    @ApiException(value=Status.SIGN_OUT_ERROR)
    public Result signOut(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, HttpServletRequest request) {
        String ip = LoginController.getClientIpAddress(request);
        this.sessionService.expireSession(loginUser.getId());
        request.removeAttribute("session.user");
        return this.success();
    }

    @DeleteMapping(value={"cookies"})
    public void clearCookieSessionId(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = request.getCookies()) {
            cookie.setMaxAge(0);
            cookie.setValue(null);
            response.addCookie(cookie);
        }
        response.setStatus(200);
    }

    @Operation(summary="getOauth2Provider", description="GET_OAUTH2_PROVIDER")
    @GetMapping(value={"oauth2-provider"})
    public Result<List<OAuth2Configuration.OAuth2ClientProperties>> oauth2Provider() {
        if (this.oAuth2Configuration == null) {
            return Result.success(new ArrayList());
        }
        Collection<OAuth2Configuration.OAuth2ClientProperties> values = this.oAuth2Configuration.getProvider().values();
        List providers = values.stream().map(e -> {
            OAuth2Configuration.OAuth2ClientProperties oAuth2ClientProperties = new OAuth2Configuration.OAuth2ClientProperties();
            oAuth2ClientProperties.setAuthorizationUri(e.getAuthorizationUri());
            oAuth2ClientProperties.setRedirectUri(e.getRedirectUri());
            oAuth2ClientProperties.setClientId(e.getClientId());
            oAuth2ClientProperties.setProvider(e.getProvider());
            oAuth2ClientProperties.setIconUri(e.getIconUri());
            return oAuth2ClientProperties;
        }).collect(Collectors.toList());
        return Result.success(providers);
    }

    @Operation(summary="getOidcProviders", description="GET_OIDC_PROVIDERS")
    @GetMapping(value={"/oidc-providers"})
    public Result<List<Map<String, String>>> oidcProviders() {
        if (this.oidcConfigProperties == null || !this.oidcConfigProperties.isEnable() || this.oidcConfigProperties.getProviders() == null) {
            return Result.success(new ArrayList());
        }
        List providers = this.oidcConfigProperties.getProviders().entrySet().stream().map(entry -> {
            HashMap provider = new HashMap();
            provider.put("id", entry.getKey());
            provider.put("displayName", ((OidcProviderConfig)entry.getValue()).getDisplayName());
            provider.put("iconUri", ((OidcProviderConfig)entry.getValue()).getIconUri());
            return provider;
        }).collect(Collectors.toList());
        return Result.success(providers);
    }

    @Operation(summary="redirectToOauth2", description="REDIRECT_TO_OAUTH2_LOGIN")
    @GetMapping(value={"redirect/login/oauth2"})
    public void loginByAuth2(@RequestParam String code, @RequestParam String provider, HttpServletRequest request, HttpServletResponse response) {
        OAuth2Configuration.OAuth2ClientProperties oAuth2ClientProperties = this.oAuth2Configuration.getProvider().get(provider);
        try {
            HashMap<String, String> tokenRequestHeader = new HashMap<String, String>();
            tokenRequestHeader.put("Accept", "application/json");
            HashMap<String, String> requestBody = new HashMap<String, String>(16);
            requestBody.put("client_secret", oAuth2ClientProperties.getClientSecret());
            HashMap<String, String> requestParamsMap = new HashMap<String, String>();
            requestParamsMap.put("client_id", oAuth2ClientProperties.getClientId());
            requestParamsMap.put("code", code);
            requestParamsMap.put("grant_type", "authorization_code");
            requestParamsMap.put("redirect_uri", String.format("%s?provider=%s", oAuth2ClientProperties.getRedirectUri(), provider));
            OkHttpRequestHeaders okHttpRequestHeadersPost = new OkHttpRequestHeaders();
            okHttpRequestHeadersPost.setHeaders(tokenRequestHeader);
            okHttpRequestHeadersPost.setOkHttpRequestHeaderContentType(OkHttpRequestHeaderContentType.APPLICATION_JSON);
            String tokenJsonStr = OkHttpUtils.post((String)oAuth2ClientProperties.getTokenUri(), (OkHttpRequestHeaders)okHttpRequestHeadersPost, requestParamsMap, requestBody, (int)60000, (int)60000, (int)60000).getBody();
            String accessToken = JSONUtils.getNodeString((String)tokenJsonStr, (String)"access_token");
            HashMap<String, String> userInfoRequestHeaders = new HashMap<String, String>();
            userInfoRequestHeaders.put("Accept", "application/json");
            HashMap<String, String> userInfoQueryMap = new HashMap<String, String>();
            userInfoQueryMap.put("access_token", accessToken);
            userInfoRequestHeaders.put("Authorization", "Bearer " + accessToken);
            OkHttpRequestHeaders okHttpRequestHeadersGet = new OkHttpRequestHeaders();
            okHttpRequestHeadersGet.setHeaders(userInfoRequestHeaders);
            String userInfoJsonStr = OkHttpUtils.get((String)oAuth2ClientProperties.getUserInfoUri(), (OkHttpRequestHeaders)okHttpRequestHeadersGet, userInfoQueryMap, (int)60000, (int)60000, (int)60000).getBody();
            String username = JSONUtils.getNodeString((String)userInfoJsonStr, (String)"login");
            User user = this.usersService.getUserByUserName(username);
            if (user == null) {
                user = this.usersService.createUser(UserType.GENERAL_USER, username, null);
            }
            Session session = this.sessionService.createSessionIfAbsent(user);
            response.setStatus(302);
            response.sendRedirect(String.format("%s?sessionId=%s&authType=%s", oAuth2ClientProperties.getCallbackUrl(), session.getId(), "oauth2"));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            response.setStatus(302);
            response.sendRedirect(String.format("%s?authType=%s&error=%s", oAuth2ClientProperties.getCallbackUrl(), "oauth2", "oauth2 auth error"));
        }
    }

    @Operation(summary="handleOidcCallback", description="HANDLE_OIDC_CALLBACK")
    @GetMapping(value={"/login/oauth2/code/{providerId}"})
    public void handleOidcCallback(@PathVariable String providerId, @RequestParam(name="code", required=false) String code, @RequestParam(name="error", required=false) String error, @RequestParam(name="state") String state, HttpServletResponse response) throws IOException {
        if (!state.startsWith(providerId + ":")) {
            log.error("OIDC login failed: State parameter does not match the provider ID.");
            response.sendRedirect("/dolphinscheduler/ui/#/login?error=oidc_invalid_state");
            return;
        }
        if (error != null) {
            String sanitizedError = error.replaceAll("[\n\r\t]", "_");
            log.error("OIDC login failed with error: {}.", (Object)sanitizedError);
            response.sendRedirect("/dolphinscheduler/ui/#/login?error=oidc_login_failed");
            return;
        }
        if (code == null) {
            log.error("OIDC login failed: The authorization code was not provided.");
            response.sendRedirect("/dolphinscheduler/ui/#/login?error=oidc_missing_code");
            return;
        }
        try {
            if (!(this.authenticator instanceof OidcAuthenticator)) {
                log.error("OIDC authentication is not active or authenticator type is incorrect.");
                response.sendRedirect("/dolphinscheduler/ui/#/login?error=oidc_not_enabled");
                return;
            }
            User user = ((OidcAuthenticator)this.authenticator).login(state, code);
            if (user == null) {
                log.error("OIDC authentication failed. User could not be authenticated or created.");
                response.sendRedirect("/dolphinscheduler/ui/#/login?error=oidc_authentication_failed");
                return;
            }
            Session session = this.sessionService.createSessionIfAbsent(user);
            response.setStatus(302);
            response.sendRedirect(String.format("%s/login?sessionId=%s&authType=%s", this.apiConfig.getUiUrl(), session.getId(), "oidc"));
        }
        catch (Exception ex) {
            log.error("A critical error occurred during the OIDC callback process.", (Throwable)ex);
            try {
                response.sendRedirect("/dolphinscheduler/ui/#/login?error=oidc_critical_error");
            }
            catch (IOException e) {
                log.error("Failed to redirect to login page after a critical error.", (Throwable)e);
            }
        }
    }

    @Operation(summary="redirectToOidc", description="REDIRECT_TO_OIDC_LOGIN")
    @GetMapping(value={"/oauth2/authorization/{providerId}"})
    public void redirectToOidc(@PathVariable String providerId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.oidcConfigProperties == null || this.oidcConfigProperties.getProviders() == null || !this.oidcConfigProperties.getProviders().containsKey(providerId)) {
            log.error("Invalid OIDC provider ID requested: {}", (Object)providerId);
            response.sendRedirect("/dolphinscheduler/ui/#/login?error=invalid_provider");
            return;
        }
        String state = providerId + ":" + UUID.randomUUID().toString();
        request.getSession().setAttribute("sso.login.user.state", (Object)state);
        String authorizationUrl = ((OidcAuthenticator)this.authenticator).getSignInUrl(state);
        if (authorizationUrl == null) {
            log.error("OIDC authorization URL is null for providerId: {}", (Object)providerId);
            response.sendRedirect("/dolphinscheduler/ui/#/login?error=oidc_authorization_url_null");
            return;
        }
        response.sendRedirect(authorizationUrl);
    }
}

