/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.command.handler;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.engine.command.handler.RunWorkflowCommandHandler;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReRunWorkflowCommandHandler
extends RunWorkflowCommandHandler {
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private MasterConfig masterConfig;

    @Override
    protected void assembleWorkflowInstance(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        Command command = workflowExecuteContextBuilder.getCommand();
        int workflowInstanceId = command.getWorkflowInstanceId();
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryOptionalById((Serializable)Integer.valueOf(workflowInstanceId)).orElseThrow(() -> new IllegalArgumentException("Cannot find WorkflowInstance:" + workflowInstanceId));
        workflowInstance.setVarPool(null);
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.RUNNING_EXECUTION, command.getCommandType().name());
        workflowInstance.setCommandType(command.getCommandType());
        workflowInstance.setRestartTime(new Date());
        workflowInstance.setHost(this.masterConfig.getMasterAddress());
        workflowInstance.setEndTime(null);
        workflowInstance.setRunTimes(workflowInstance.getRunTimes() + 1);
        this.workflowInstanceDao.updateById((Object)workflowInstance);
        workflowExecuteContextBuilder.setWorkflowInstance(workflowInstance);
    }

    @Override
    protected void assembleWorkflowExecutionGraph(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        this.markAllTaskInstanceInvalid(workflowExecuteContextBuilder);
        super.assembleWorkflowExecutionGraph(workflowExecuteContextBuilder);
    }

    private void markAllTaskInstanceInvalid(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        WorkflowInstance workflowInstance = workflowExecuteContextBuilder.getWorkflowInstance();
        List<TaskInstance> taskInstances = this.getValidTaskInstance(workflowInstance);
        this.taskInstanceDao.markTaskInstanceInvalid(taskInstances);
    }

    @Override
    public CommandType commandType() {
        return CommandType.REPEAT_RUNNING;
    }
}

