/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin.switchtask;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.SwitchResultVo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SwitchParameters;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.AbstractLogicTask;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.ITaskParameterDeserializer;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.runner.IWorkflowExecuteContext;
import org.apache.dolphinscheduler.server.master.utils.SwitchTaskUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchLogicTask
extends AbstractLogicTask<SwitchParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchLogicTask.class);
    private final IWorkflowExecutionRunnable workflowExecutionRunnable;
    private final TaskInstance taskInstance;

    public SwitchLogicTask(IWorkflowExecutionRunnable workflowExecutionRunnable, TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.workflowExecutionRunnable = workflowExecutionRunnable;
        this.taskInstance = workflowExecutionRunnable.getWorkflowExecuteContext().getWorkflowExecutionGraph().getTaskExecutionRunnableById(taskExecutionContext.getTaskInstanceId()).getTaskInstance();
        this.onTaskRunning();
    }

    @Override
    public void start() {
        if (CollectionUtils.isEmpty((Collection)((SwitchParameters)this.taskParameters).getSwitchResult().getDependTaskList())) {
            log.info("The switch items is empty");
            this.moveToDefaultBranch();
        } else {
            this.calculateSwitchBranch();
        }
        this.checkIfBranchExist(((SwitchParameters)this.taskParameters).getNextBranch());
        this.taskInstance.setTaskParams(JSONUtils.toJsonString((Object)this.taskParameters));
        this.onTaskSuccess();
        log.info("Switch task execute finished");
    }

    private void moveToDefaultBranch() {
        log.info("Begin to move to the default branch");
        if (((SwitchParameters)this.taskParameters).getSwitchResult().getNextNode() == null) {
            throw new IllegalArgumentException("The default branch is empty, please check the switch task configuration");
        }
        ((SwitchParameters)this.taskParameters).setNextBranch(((SwitchParameters)this.taskParameters).getSwitchResult().getNextNode());
        log.info("The condition is not satisfied, move to the default branch: {}", (Object)this.getTaskName(((SwitchParameters)this.taskParameters).getNextBranch()));
    }

    private void calculateSwitchBranch() {
        List switchResultVos = ((SwitchParameters)this.taskParameters).getSwitchResult().getDependTaskList();
        Map globalParams = this.taskExecutionContext.getPrepareParamsMap();
        Map<String, Property> varParams = JSONUtils.toList((String)this.taskInstance.getVarPool(), Property.class).stream().collect(Collectors.toMap(Property::getProp, Property2 -> Property2));
        Long nextBranch = null;
        for (SwitchResultVo switchResultVo : switchResultVos) {
            log.info("Begin to execute switch item: {} ", (Object)switchResultVo);
            try {
                String content = SwitchTaskUtils.generateContentWithTaskParams(switchResultVo.getCondition(), globalParams, varParams);
                log.info("Format condition sentence::{} successfully", (Object)content);
                boolean conditionResult = SwitchTaskUtils.evaluate(content);
                log.info("Execute condition sentence: {} successfully: {}", (Object)content, (Object)conditionResult);
                if (!conditionResult) continue;
                nextBranch = switchResultVo.getNextNode();
                break;
            }
            catch (Exception e) {
                log.info("Execute switch item: {} failed", (Object)switchResultVo, (Object)e);
            }
        }
        if (nextBranch == null) {
            log.info("All switch item is not satisfied");
            this.moveToDefaultBranch();
        } else {
            log.info("The condition is satisfied, move to the next branch: {}", (Object)this.getTaskName(nextBranch));
            ((SwitchParameters)this.taskParameters).setNextBranch(nextBranch);
        }
    }

    private void checkIfBranchExist(Long branchNode) {
        if (branchNode == null) {
            throw new IllegalArgumentException("The branch is empty, please check the switch task configuration");
        }
        if (this.workflowExecutionRunnable.getWorkflowExecuteContext().getWorkflowGraph().getTaskNodeByCode(branchNode) == null) {
            throw new IllegalArgumentException("The branch(code= " + branchNode + ") is not in the dag, please check the switch task configuration");
        }
    }

    private String getTaskName(Long taskCode) {
        return Optional.ofNullable(this.workflowExecutionRunnable.getWorkflowExecuteContext()).map(IWorkflowExecuteContext::getWorkflowGraph).map(iWorkflowGraph -> iWorkflowGraph.getTaskNodeByCode(taskCode)).map(TaskDefinition::getName).orElse(null);
    }

    @Override
    public void pause() {
        log.info("The SwitchTask does not support pause operation");
    }

    @Override
    public void kill() {
        log.info("The SwitchTask does not support kill operation");
    }

    @Override
    public ITaskParameterDeserializer<SwitchParameters> getTaskParameterDeserializer() {
        return taskParamsJson -> (SwitchParameters)JSONUtils.parseObject((String)taskParamsJson, (TypeReference)new TypeReference<SwitchParameters>(){});
    }
}

