/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.trigger;

import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.utils.EnvironmentUtils;
import org.apache.dolphinscheduler.dao.utils.WorkerGroupUtils;
import org.apache.dolphinscheduler.extract.master.command.ScheduleWorkflowCommandParam;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowScheduleTriggerRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowScheduleTriggerResponse;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.AbstractWorkflowTrigger;
import org.springframework.stereotype.Component;

@Component
public class WorkflowScheduleTrigger
extends AbstractWorkflowTrigger<WorkflowScheduleTriggerRequest, WorkflowScheduleTriggerResponse> {
    @Override
    protected ImmutablePair<WorkflowDefinition, WorkflowInstance> constructWorkflowInstance(WorkflowScheduleTriggerRequest scheduleTriggerRequest) {
        CommandType commandType = CommandType.SCHEDULER;
        Long workflowCode = scheduleTriggerRequest.getWorkflowCode();
        Integer workflowVersion = scheduleTriggerRequest.getWorkflowVersion();
        WorkflowDefinition workflowDefinition = this.getProcessDefinition(workflowCode, workflowVersion);
        WorkflowInstance workflowInstance = new WorkflowInstance();
        workflowInstance.setWorkflowDefinitionCode(Long.valueOf(workflowDefinition.getCode()));
        workflowInstance.setWorkflowDefinitionVersion(workflowDefinition.getVersion());
        workflowInstance.setProjectCode(Long.valueOf(workflowDefinition.getProjectCode()));
        workflowInstance.setCommandType(commandType);
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.SUBMITTED_SUCCESS, commandType.name());
        workflowInstance.setRecovery(Flag.NO);
        workflowInstance.setScheduleTime(scheduleTriggerRequest.getScheduleTIme());
        workflowInstance.setStartTime(new Date());
        workflowInstance.setRestartTime(workflowInstance.getStartTime());
        workflowInstance.setRunTimes(1);
        workflowInstance.setName(String.join((CharSequence)"-", workflowDefinition.getName(), DateUtils.getCurrentTimeStamp()));
        workflowInstance.setTaskDependType(scheduleTriggerRequest.getTaskDependType());
        workflowInstance.setFailureStrategy(scheduleTriggerRequest.getFailureStrategy());
        workflowInstance.setWarningType((WarningType)ObjectUtils.defaultIfNull((Object)scheduleTriggerRequest.getWarningType(), (Object)WarningType.NONE));
        workflowInstance.setWarningGroupId(scheduleTriggerRequest.getWarningGroupId());
        workflowInstance.setExecutorId(scheduleTriggerRequest.getUserId().intValue());
        workflowInstance.setExecutorName(this.getExecutorUser(scheduleTriggerRequest.getUserId()).getUserName());
        workflowInstance.setTenantCode(scheduleTriggerRequest.getTenantCode());
        workflowInstance.setIsSubWorkflow(Flag.NO);
        workflowInstance.addHistoryCmd(commandType);
        workflowInstance.setWorkflowInstancePriority(scheduleTriggerRequest.getWorkflowInstancePriority());
        workflowInstance.setWorkerGroup(WorkerGroupUtils.getWorkerGroupOrDefault((String)scheduleTriggerRequest.getWorkerGroup()));
        workflowInstance.setEnvironmentCode(EnvironmentUtils.getEnvironmentCodeOrDefault((Long)scheduleTriggerRequest.getEnvironmentCode()));
        workflowInstance.setTimeout(workflowDefinition.getTimeout());
        workflowInstance.setDryRun(scheduleTriggerRequest.getDryRun().getCode());
        return ImmutablePair.of((Object)workflowDefinition, (Object)workflowInstance);
    }

    @Override
    protected Command constructTriggerCommand(WorkflowScheduleTriggerRequest scheduleTriggerRequest, WorkflowInstance workflowInstance) {
        ScheduleWorkflowCommandParam scheduleWorkflowCommandParam = ((ScheduleWorkflowCommandParam.ScheduleWorkflowCommandParamBuilder)ScheduleWorkflowCommandParam.builder().timeZone(scheduleTriggerRequest.getTimezoneId())).build();
        return Command.builder().commandType(CommandType.SCHEDULER).workflowDefinitionCode(scheduleTriggerRequest.getWorkflowCode().longValue()).workflowDefinitionVersion(scheduleTriggerRequest.getWorkflowVersion().intValue()).workflowInstanceId(workflowInstance.getId().intValue()).workflowInstancePriority(workflowInstance.getWorkflowInstancePriority()).commandParam(JSONUtils.toJsonString((Object)scheduleWorkflowCommandParam)).build();
    }

    @Override
    protected WorkflowScheduleTriggerResponse onTriggerSuccess(WorkflowInstance workflowInstance) {
        return WorkflowScheduleTriggerResponse.success((Integer)workflowInstance.getId());
    }
}

