/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReadOnlyEndpoint;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReadWriteEndpoint;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReplicationRole;
import com.azure.resourcemanager.sql.models.ManagedInstancePairInfo;
import com.azure.resourcemanager.sql.models.PartnerRegionInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class InstanceFailoverGroupProperties {
    @JsonProperty(value="readWriteEndpoint", required=true)
    private InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint;
    @JsonProperty(value="readOnlyEndpoint")
    private InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint;
    @JsonProperty(value="replicationRole", access=JsonProperty.Access.WRITE_ONLY)
    private InstanceFailoverGroupReplicationRole replicationRole;
    @JsonProperty(value="replicationState", access=JsonProperty.Access.WRITE_ONLY)
    private String replicationState;
    @JsonProperty(value="partnerRegions", required=true)
    private List<PartnerRegionInfo> partnerRegions;
    @JsonProperty(value="managedInstancePairs", required=true)
    private List<ManagedInstancePairInfo> managedInstancePairs;
    private static final ClientLogger LOGGER = new ClientLogger(InstanceFailoverGroupProperties.class);

    public InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.readWriteEndpoint;
    }

    public InstanceFailoverGroupProperties withReadWriteEndpoint(InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint) {
        this.readWriteEndpoint = readWriteEndpoint;
        return this;
    }

    public InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.readOnlyEndpoint;
    }

    public InstanceFailoverGroupProperties withReadOnlyEndpoint(InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        this.readOnlyEndpoint = readOnlyEndpoint;
        return this;
    }

    public InstanceFailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

    public String replicationState() {
        return this.replicationState;
    }

    public List<PartnerRegionInfo> partnerRegions() {
        return this.partnerRegions;
    }

    public InstanceFailoverGroupProperties withPartnerRegions(List<PartnerRegionInfo> partnerRegions) {
        this.partnerRegions = partnerRegions;
        return this;
    }

    public List<ManagedInstancePairInfo> managedInstancePairs() {
        return this.managedInstancePairs;
    }

    public InstanceFailoverGroupProperties withManagedInstancePairs(List<ManagedInstancePairInfo> managedInstancePairs) {
        this.managedInstancePairs = managedInstancePairs;
        return this;
    }

    public void validate() {
        if (this.readWriteEndpoint() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property readWriteEndpoint in model InstanceFailoverGroupProperties"));
        }
        this.readWriteEndpoint().validate();
        if (this.readOnlyEndpoint() != null) {
            this.readOnlyEndpoint().validate();
        }
        if (this.partnerRegions() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property partnerRegions in model InstanceFailoverGroupProperties"));
        }
        this.partnerRegions().forEach(e -> e.validate());
        if (this.managedInstancePairs() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property managedInstancePairs in model InstanceFailoverGroupProperties"));
        }
        this.managedInstancePairs().forEach(e -> e.validate());
    }
}

