/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.extract.base.config.NettyServerConfig;
import org.apache.dolphinscheduler.extract.base.exception.RemoteException;
import org.apache.dolphinscheduler.extract.base.protocal.TransporterDecoder;
import org.apache.dolphinscheduler.extract.base.protocal.TransporterEncoder;
import org.apache.dolphinscheduler.extract.base.server.JdkDynamicServerHandler;
import org.apache.dolphinscheduler.extract.base.server.ServerMethodInvoker;
import org.apache.dolphinscheduler.extract.base.utils.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyRemotingServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyRemotingServer.class);
    private Channel serverBootstrapChannel;
    private final String serverName;
    private final ExecutorService methodInvokerExecutor;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workGroup;
    private final NettyServerConfig serverConfig;
    private final JdkDynamicServerHandler channelHandler;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    NettyRemotingServer(NettyServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.serverName = serverConfig.getServerName();
        this.methodInvokerExecutor = ThreadUtils.newDaemonFixedThreadExecutor((String)(this.serverName + "-methodInvoker-%d"), (int)(Runtime.getRuntime().availableProcessors() * 2 + 1));
        this.channelHandler = new JdkDynamicServerHandler(this.methodInvokerExecutor);
        ThreadFactory bossThreadFactory = ThreadUtils.newDaemonThreadFactory((String)(this.serverName + "-boss-%d"));
        ThreadFactory workerThreadFactory = ThreadUtils.newDaemonThreadFactory((String)(this.serverName + "-worker-%d"));
        if (Epoll.isAvailable()) {
            this.bossGroup = new EpollEventLoopGroup(1, bossThreadFactory);
            this.workGroup = new EpollEventLoopGroup(serverConfig.getWorkerThread(), workerThreadFactory);
        } else {
            this.bossGroup = new NioEventLoopGroup(1, bossThreadFactory);
            this.workGroup = new NioEventLoopGroup(serverConfig.getWorkerThread(), workerThreadFactory);
        }
    }

    void start() {
        if (this.isStarted.compareAndSet(false, true)) {
            ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workGroup).channel(NettyUtils.getServerSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)this.serverConfig.getSoBacklog())).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.serverConfig.isSoKeepalive()).childOption(ChannelOption.TCP_NODELAY, (Object)this.serverConfig.isTcpNoDelay()).childOption(ChannelOption.SO_SNDBUF, (Object)this.serverConfig.getSendBufferSize()).childOption(ChannelOption.SO_RCVBUF, (Object)this.serverConfig.getReceiveBufferSize()).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    NettyRemotingServer.this.initNettyChannel(ch);
                }
            });
            try {
                ChannelFuture channelFuture = serverBootstrap.bind(this.serverConfig.getListenPort()).sync();
                if (!channelFuture.isSuccess()) {
                    throw new RemoteException(String.format("%s bind %s fail", this.serverConfig.getServerName(), this.serverConfig.getListenPort()), channelFuture.cause());
                }
                log.info("{} bind success at port: {}", (Object)this.serverConfig.getServerName(), (Object)this.serverConfig.getListenPort());
                this.serverBootstrapChannel = channelFuture.channel();
            }
            catch (InterruptedException it) {
                ThreadUtils.rethrowInterruptedException((InterruptedException)it);
            }
            catch (Exception e) {
                throw new RemoteException(String.format("%s bind %s fail", this.serverConfig.getServerName(), this.serverConfig.getListenPort()), e);
            }
        }
    }

    private void initNettyChannel(SocketChannel ch) {
        ch.pipeline().addLast("encoder", (ChannelHandler)new TransporterEncoder()).addLast("decoder", (ChannelHandler)new TransporterDecoder()).addLast("server-idle-handle", (ChannelHandler)new IdleStateHandler(this.serverConfig.getConnectionIdleTime(), 0L, 0L, TimeUnit.MILLISECONDS)).addLast("handler", (ChannelHandler)this.channelHandler);
    }

    void registerMethodInvoker(ServerMethodInvoker methodInvoker) {
        this.channelHandler.registerMethodInvoker(methodInvoker);
    }

    void close() {
        if (this.isStarted.compareAndSet(true, false)) {
            log.info("{} closing", (Object)this.serverConfig.getServerName());
            try {
                if (this.serverBootstrapChannel != null) {
                    this.serverBootstrapChannel.close().sync();
                    log.info("{} stop bind at port: {}", (Object)this.serverConfig.getServerName(), (Object)this.serverConfig.getListenPort());
                }
                if (this.bossGroup != null) {
                    this.bossGroup.shutdownGracefully();
                }
                if (this.workGroup != null) {
                    this.workGroup.shutdownGracefully();
                }
                this.methodInvokerExecutor.shutdownNow();
            }
            catch (InterruptedException it) {
                ThreadUtils.consumeInterruptedException((InterruptedException)it);
            }
            catch (Exception ex) {
                log.error("{} close failed", (Object)this.serverConfig.getServerName(), (Object)ex);
            }
            log.info("{} closed", (Object)this.serverConfig.getServerName());
        }
    }

    @Generated
    public String getServerName() {
        return this.serverName;
    }

    @Generated
    public ExecutorService getMethodInvokerExecutor() {
        return this.methodInvokerExecutor;
    }
}

