/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model.fs;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TaskProgressStatus;
import com.obs.services.model.fs.DropFolderRequest;
import com.obs.services.model.fs.ObsFSAttribute;
import com.obs.services.model.fs.RenameRequest;
import com.obs.services.model.fs.RenameResult;

public class ObsFSFolder
extends PutObjectResult {
    protected ObsClient innerClient;

    public ObsFSFolder(String bucketName, String objectKey, String etag, String versionId, StorageClassEnum storageClass, String objectUrl) {
        super(bucketName, objectKey, etag, versionId, storageClass, objectUrl);
    }

    protected void setInnerClient(ObsClient innerClient) {
        this.innerClient = innerClient;
    }

    public ObsFSAttribute attribute() throws ObsException {
        this.checkInternalClient();
        return (ObsFSAttribute)this.innerClient.getObjectMetadata(this.getBucketName(), this.getObjectKey());
    }

    public RenameResult rename(String newName) throws ObsException {
        this.checkInternalClient();
        RenameRequest request = new RenameRequest(this.getBucketName(), this.getObjectKey(), newName);
        return this.innerClient.renameFolder(request);
    }

    public TaskProgressStatus dropFolder() throws ObsException {
        this.checkInternalClient();
        DropFolderRequest request = new DropFolderRequest(this.getBucketName(), this.getObjectKey());
        return this.innerClient.dropFolder(request);
    }

    protected void checkInternalClient() {
        ServiceUtils.assertParameterNotNull(this.innerClient, "ObsClient is null");
    }
}

