/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.run;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.extended.run.EditableRunConfig;
import io.fabric8.kubernetes.client.extended.run.RunConfig;
import io.fabric8.kubernetes.client.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.client.extended.run.RunConfigUtil;

public class RunOperations {
    private final KubernetesClient client;
    private final RunConfigBuilder runConfigBuilder;

    public RunOperations(KubernetesClient client, RunConfigBuilder runConfigBuilder) {
        this.client = client;
        this.runConfigBuilder = runConfigBuilder;
    }

    public RunOperations inNamespace(String namespace) {
        return new RunOperations(this.client.adapt(NamespacedKubernetesClient.class).inNamespace(namespace), this.runConfigBuilder);
    }

    public RunOperations withImage(String image) {
        return new RunOperations(this.client, (RunConfigBuilder)this.runConfigBuilder.withImage(image));
    }

    public RunOperations withName(String name) {
        return new RunOperations(this.client, (RunConfigBuilder)this.runConfigBuilder.withName(name));
    }

    public RunOperations withRunConfig(RunConfig generatorRunConfig) {
        return new RunOperations(this.client, new RunConfigBuilder(generatorRunConfig));
    }

    public Pod done() {
        return (Pod)((PodResource)this.client.pods().resource(this.convertRunConfigIntoPod())).create();
    }

    Pod convertRunConfigIntoPod() {
        EditableRunConfig finalGeneratorConfig = this.runConfigBuilder.build();
        return ((PodBuilder)((PodBuilder)new PodBuilder().withMetadata(RunConfigUtil.getObjectMetadataFromRunConfig(finalGeneratorConfig))).withSpec(RunConfigUtil.getPodSpecFromRunConfig(finalGeneratorConfig))).build();
    }
}

