/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.arm;

public final class ResourceId {
    private final String subscriptionId;
    private final String resourceGroupName;
    private final String name;
    private final String providerNamespace;
    private final String resourceType;
    private final String id;
    private final String parentId;

    private static String badIdErrorText(String id) {
        return String.format("The specified ID `%s` is not a valid Azure resource ID.", id);
    }

    private ResourceId(String id) {
        String[] splits;
        if (id == null) {
            this.subscriptionId = null;
            this.resourceGroupName = null;
            this.name = null;
            this.providerNamespace = null;
            this.resourceType = null;
            this.id = null;
            this.parentId = null;
            return;
        }
        String[] stringArray = splits = id.startsWith("/") ? id.substring(1).split("/") : id.split("/");
        if (splits.length % 2 == 1) {
            throw new IllegalArgumentException(ResourceId.badIdErrorText(id));
        }
        this.id = id;
        if (splits.length < 2) {
            throw new IllegalArgumentException(ResourceId.badIdErrorText(id));
        }
        this.name = splits[splits.length - 1];
        this.resourceType = splits[splits.length - 2];
        if (splits.length < 10) {
            this.parentId = null;
        } else {
            CharSequence[] parentSplits = new String[splits.length - 2];
            System.arraycopy(splits, 0, parentSplits, 0, splits.length - 2);
            this.parentId = "/" + String.join((CharSequence)"/", parentSplits);
        }
        if (!splits[0].equalsIgnoreCase("subscriptions")) {
            throw new IllegalArgumentException(ResourceId.badIdErrorText(id));
        }
        this.subscriptionId = splits[1];
        if (splits.length > 2 && !splits[2].equalsIgnoreCase("resourceGroups")) {
            throw new IllegalArgumentException(ResourceId.badIdErrorText(id));
        }
        String string = this.resourceGroupName = splits.length > 3 ? splits[3] : null;
        if (splits.length > 4 && !splits[4].equalsIgnoreCase("providers")) {
            throw new IllegalArgumentException(ResourceId.badIdErrorText(id));
        }
        this.providerNamespace = splits.length > 5 ? splits[5] : null;
    }

    public static ResourceId fromString(String id) {
        return new ResourceId(id);
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String name() {
        return this.name;
    }

    public ResourceId parent() {
        if (this.id == null || this.parentId == null) {
            return null;
        }
        return ResourceId.fromString(this.parentId);
    }

    public String providerNamespace() {
        return this.providerNamespace;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String fullResourceType() {
        if (this.parentId == null) {
            return this.providerNamespace + "/" + this.resourceType;
        }
        return this.parent().fullResourceType() + "/" + this.resourceType;
    }

    public String id() {
        return this.id;
    }
}

