/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.fluent.models.WebhookPropertiesCreateParameters;
import com.azure.resourcemanager.containerregistry.models.WebhookAction;
import com.azure.resourcemanager.containerregistry.models.WebhookStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class WebhookCreateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WebhookCreateParameters.class);
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="properties")
    private WebhookPropertiesCreateParameters innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public WebhookCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String location() {
        return this.location;
    }

    public WebhookCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    private WebhookPropertiesCreateParameters innerProperties() {
        return this.innerProperties;
    }

    public String serviceUri() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceUri();
    }

    public WebhookCreateParameters withServiceUri(String serviceUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPropertiesCreateParameters();
        }
        this.innerProperties().withServiceUri(serviceUri);
        return this;
    }

    public Map<String, String> customHeaders() {
        return this.innerProperties() == null ? null : this.innerProperties().customHeaders();
    }

    public WebhookCreateParameters withCustomHeaders(Map<String, String> customHeaders) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPropertiesCreateParameters();
        }
        this.innerProperties().withCustomHeaders(customHeaders);
        return this;
    }

    public WebhookStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public WebhookCreateParameters withStatus(WebhookStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPropertiesCreateParameters();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    public WebhookCreateParameters withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPropertiesCreateParameters();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    public List<WebhookAction> actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    public WebhookCreateParameters withActions(List<WebhookAction> actions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebhookPropertiesCreateParameters();
        }
        this.innerProperties().withActions(actions);
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model WebhookCreateParameters"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

