/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewayAuthenticationCertificate;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpSettings;
import com.azure.resourcemanager.network.models.ApplicationGatewayConnectionDraining;
import com.azure.resourcemanager.network.models.ApplicationGatewayCookieBasedAffinity;
import com.azure.resourcemanager.network.models.ApplicationGatewayProbe;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class ApplicationGatewayBackendHttpConfigurationImpl
extends ChildResourceImpl<ApplicationGatewayBackendHttpSettings, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayBackendHttpConfiguration,
ApplicationGatewayBackendHttpConfiguration.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayBackendHttpConfiguration.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayBackendHttpConfiguration.Update {
    ApplicationGatewayBackendHttpConfigurationImpl(ApplicationGatewayBackendHttpSettings inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    @Override
    public Map<String, ApplicationGatewayAuthenticationCertificate> authenticationCertificates() {
        TreeMap<String, ApplicationGatewayAuthenticationCertificate> certs = new TreeMap<String, ApplicationGatewayAuthenticationCertificate>();
        if (((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).authenticationCertificates() == null) {
            return Collections.unmodifiableMap(certs);
        }
        for (SubResource ref : ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).authenticationCertificates()) {
            ApplicationGatewayAuthenticationCertificate cert = ((ApplicationGatewayImpl)this.parent()).authenticationCertificates().get(ResourceUtils.nameFromResourceId((String)ref.id()));
            if (cert == null) continue;
            certs.put(cert.name(), cert);
        }
        return Collections.unmodifiableMap(certs);
    }

    public String name() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).name();
    }

    @Override
    public ApplicationGatewayProbe probe() {
        if (((ApplicationGatewayImpl)this.parent()).probes() != null && ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).probe() != null) {
            return ((ApplicationGatewayImpl)this.parent()).probes().get(ResourceUtils.nameFromResourceId((String)((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).probe().id()));
        }
        return null;
    }

    @Override
    public String hostHeader() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).hostname();
    }

    @Override
    public boolean isHostHeaderFromBackend() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).pickHostnameFromBackendAddress());
    }

    @Override
    public boolean isProbeEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).probeEnabled());
    }

    @Override
    public int connectionDrainingTimeoutInSeconds() {
        if (((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).connectionDraining() == null) {
            return 0;
        }
        if (!((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).connectionDraining().enabled()) {
            return 0;
        }
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).connectionDraining().drainTimeoutInSec();
    }

    @Override
    public String affinityCookieName() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).affinityCookieName();
    }

    @Override
    public String path() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).path();
    }

    @Override
    public int port() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).port());
    }

    @Override
    public ApplicationGatewayProtocol protocol() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).protocol();
    }

    @Override
    public boolean cookieBasedAffinity() {
        return ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).cookieBasedAffinity().equals((Object)ApplicationGatewayCookieBasedAffinity.ENABLED);
    }

    @Override
    public int requestTimeout() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).requestTimeout());
    }

    public ApplicationGatewayImpl attach() {
        ((ApplicationGatewayImpl)this.parent()).withBackendHttpConfiguration(this);
        return (ApplicationGatewayImpl)this.parent();
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withPort(int port) {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withPort(port);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withCookieBasedAffinity() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withCookieBasedAffinity(ApplicationGatewayCookieBasedAffinity.ENABLED);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutCookieBasedAffinity() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withCookieBasedAffinity(ApplicationGatewayCookieBasedAffinity.DISABLED);
        return this;
    }

    private ApplicationGatewayBackendHttpConfigurationImpl withProtocol(ApplicationGatewayProtocol protocol) {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withProtocol(protocol);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withRequestTimeout(int seconds) {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withRequestTimeout(seconds);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withProbe(String name) {
        if (name == null) {
            return this.withoutProbe();
        }
        SubResource probeRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/probes/" + name);
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withProbe(probeRef);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutProbe() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withProbe(null);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withHostHeaderFromBackend() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withPickHostnameFromBackendAddress(true).withHostname(null);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withHostHeader(String hostHeader) {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withHostname(hostHeader).withPickHostnameFromBackendAddress(false);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutHostHeader() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withHostname(null).withPickHostnameFromBackendAddress(false);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withConnectionDrainingTimeoutInSeconds(int seconds) {
        if (((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).connectionDraining() == null) {
            ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withConnectionDraining(new ApplicationGatewayConnectionDraining());
        }
        if (seconds > 0) {
            ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).connectionDraining().withDrainTimeoutInSec(seconds).withEnabled(true);
        }
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutConnectionDraining() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withConnectionDraining(null);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withAffinityCookieName(String name) {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withAffinityCookieName(name);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withPath(String path) {
        if (path != null) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
        }
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withPath(path);
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withAuthenticationCertificate(String name) {
        if (name == null) {
            return this;
        }
        SubResource certRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/authenticationCertificates/" + name);
        List<SubResource> refs = ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).authenticationCertificates();
        if (refs == null) {
            refs = new ArrayList<SubResource>();
            ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withAuthenticationCertificates(refs);
        }
        for (SubResource ref : refs) {
            if (!ref.id().equalsIgnoreCase(certRef.id())) continue;
            return this;
        }
        refs.add(certRef);
        return this.withHttps();
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withAuthenticationCertificateFromBytes(byte[] derData) {
        if (derData == null) {
            return this;
        }
        String encoded = new String(Base64.getEncoder().encode(derData), StandardCharsets.UTF_8);
        return this.withAuthenticationCertificateFromBase64(encoded);
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withAuthenticationCertificateFromBase64(String base64Data) {
        if (base64Data == null) {
            return this;
        }
        String certName = null;
        for (ApplicationGatewayAuthenticationCertificate cert : ((ApplicationGatewayImpl)this.parent()).authenticationCertificates().values()) {
            if (!cert.data().contentEquals(base64Data)) continue;
            certName = cert.name();
            break;
        }
        if (certName == null) {
            certName = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("cert", 20);
            ((ApplicationGatewayImpl)this.parent()).defineAuthenticationCertificate(certName).fromBase64(base64Data).attach();
        }
        return this.withAuthenticationCertificate(certName).withHttps();
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withAuthenticationCertificateFromFile(File certificateFile) throws IOException {
        if (certificateFile == null) {
            return this;
        }
        byte[] content = Files.readAllBytes(certificateFile.toPath());
        return this.withAuthenticationCertificateFromBytes(content);
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutAuthenticationCertificate(String name) {
        if (name == null) {
            return this;
        }
        for (SubResource ref : ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).authenticationCertificates()) {
            if (!ResourceUtils.nameFromResourceId((String)ref.id()).equalsIgnoreCase(name)) continue;
            ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).authenticationCertificates().remove(ref);
            break;
        }
        return this;
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withHttps() {
        return this.withProtocol(ApplicationGatewayProtocol.HTTPS);
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withHttp() {
        return this.withoutAuthenticationCertificates().withProtocol(ApplicationGatewayProtocol.HTTP);
    }

    @Override
    public ApplicationGatewayBackendHttpConfigurationImpl withoutAuthenticationCertificates() {
        ((ApplicationGatewayBackendHttpSettings)((Object)this.innerModel())).withAuthenticationCertificates(null);
        return this;
    }
}

